package cn.tuia.mango.core.enums;

import java.util.Objects;

/**
 * 编码-描述型的枚举
 * @author lijicong
 * @since 2020-03-21
 */
public interface CodeDescriptionEnumerable<K, V> extends Enumerable {

    /**
     * 获取code
     * @return
     */
    K getCode();

    /**
     * 获取描述信息
     * @return
     */
    V getDescription();

    /**
     * 判断
     * @param code
     * @return
     */
    default boolean is(K code) {
        return getCode().equals(code);
    }

    /**
     * 获取int类型的code，<strong>警告</strong>，如果code不能转成整形，会抛异常
     * @return
     */
    default int intCode() {
        return Integer.valueOf(Objects.toString(getCode()));
    }

}
