package cn.tuia.mango.core.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lijicong
 * @since 2020-03-21
 */
public abstract class CommonEnums {

    @AllArgsConstructor
    @Getter
    public enum ResultCode implements ResultCodeEnumerable {
        // 通用
        SUCCESS("0", "成功"),
        OK("0", "OK"), // alias for sucess

        // 4xx 客户端请求错误
        BAD_REQUEST("400", "Bad Request"),
        UNAUTHORIZED("401", "Unauthorized"),
        FORBIDDEN("403", "Forbidden"),
        NOT_FOUND("404", "Not Found"),
        METHOD_NOT_ALLOWED("405", "Method Not Allowed"),
        NOT_ACCEPTABLE("406", "Not Acceptable"),
        REQUEST_TIMEOUT("408", "Request Timeout"),
        LOCKED("423", "Locked"),

        // 5xx 服务端错误
        INTERNAL_SERVER_ERROR("500", "Internal Server Error"),
        NOT_IMPLEMENTED("501", "Not Implemented"),
        BAD_GATEWAY("502", "Bad Gateway"),
        SERVICE_UNAVAILABLE("503", "Service Unavailable"),
        GATEWAY_TIMEOUT("504", "Gateway Timeout"),

        ;

        private String code;

        private String description;
    }

    @AllArgsConstructor
    @Getter
    public enum ErrorCode implements ResultCodeEnumerable {
        // 业务异常
        E0400001("0400001", "参数为空"),
        E0400002("0400002", "未查询到用户信息"),
        E0400003("0400003", "无效的业务类型"),
        E0400004("0400004", "正在处理中");

        private String code;

        private String description;
    }


}
