package cn.tuia.mango.core.util;

import cn.tuia.mango.core.util.DateFormatKit.DateFormat;
import org.springframework.util.StringUtils;

import java.security.SecureRandom;
import java.util.Date;
import java.util.UUID;

/**
 * @author lijicong
 * @since 2020-04-11
 */
public abstract class IdHelper {

    public static final String COLON = ":";

    private static final ThreadLocal<SecureRandom> randomHolder = ThreadLocal.withInitial(() -> new SecureRandom());

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uuid(String prefix) {
        if (StringUtils.hasText(prefix)) {
            return prefix + COLON + uuid();
        }
        return uuid();
    }

    public static String orderId() {
        return DateFormat.DATETIME_MS_NO.format(new Date()) + String.format("%03d", randomHolder.get().nextInt(999));
    }

    public static String orderId(String prefix) {
        if (StringUtils.hasText(prefix)) {
            return prefix + orderId();
        }
        return orderId();
    }
}
