/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.core.domain.api;

import cn.tuia.mango.core.domain.api.ApiResult;
import cn.tuia.mango.core.enums.CommonEnums;
import cn.tuia.mango.core.enums.ResultCodeEnumerable;

public class Results {
    public static <T> ApiResult<T> success() {
        return new ApiResult(CommonEnums.ResultCode.SUCCESS);
    }

    public static <T> ApiResult<T> success(T data) {
        ApiResult<T> result = new ApiResult<T>(CommonEnums.ResultCode.SUCCESS);
        result.setData(data);
        return result;
    }

    public static <T> ApiResult<T> success(T data, String desc) {
        ApiResult<T> result = new ApiResult<T>(CommonEnums.ResultCode.SUCCESS.getCode(), desc);
        result.setData(data);
        return result;
    }

    public static <T> ApiResult<T> fail(String code, String desc) {
        return new ApiResult(code, desc);
    }

    public static <T> ApiResult<T> fail(ResultCodeEnumerable resultCode) {
        return new ApiResult(resultCode);
    }

    public static <T> boolean isSuccess(ApiResult<T> result) {
        return result != null && CommonEnums.ResultCode.SUCCESS.getCode().equals(result.getCode());
    }

    public static <T> ApiResult<T> badRequest() {
        return new ApiResult(CommonEnums.ResultCode.BAD_REQUEST);
    }

    public static <T> ApiResult<T> unauthorized() {
        return new ApiResult(CommonEnums.ResultCode.UNAUTHORIZED);
    }

    public static <T> ApiResult<T> forbidden() {
        return new ApiResult(CommonEnums.ResultCode.FORBIDDEN);
    }

    public static <T> ApiResult<T> locked() {
        return new ApiResult(CommonEnums.ResultCode.LOCKED);
    }

    public static <T> ApiResult<T> gatewayTimeout() {
        return new ApiResult(CommonEnums.ResultCode.GATEWAY_TIMEOUT);
    }
}

