/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateFormatKit {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_MS_PATTERN = "yyyy-MM-dd HH:mm:ss:SSS";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final String DATE_NO_PATTERN = "yyyyMMdd";
    public static final String DATETIME_NO_PATTERN = "yyyyMMddHHmmss";
    public static final String DATETIME_MS_NO_PATTERN = "yyyyMMddHHmmssSSS";
    public static final String TIME_NO_PATTERN = "HHmmss";
    public static final String TIME_MS_NO_PATTERN = "HHmmssSSS";
    public static final String YEAR_PATTERN = "yyyy";
    public static final String MONTH_PATTERN = "MM";
    public static final String DAY_PATTERN = "dd";
    public static final String YEAR_MONTH_PATTERN = "yyyyMM";

    public static String formatDate(Date date) {
        return DateFormat.DATE.format(date);
    }

    public static String formatDateTime(Date date) {
        return DateFormat.DATETIME.format(date);
    }

    public static String formatDateTimeMillisNo(Date date) {
        return DateFormat.DATETIME_MS_NO.format(date);
    }

    public static enum DateFormat {
        DATE("yyyy-MM-dd"),
        DATETIME("yyyy-MM-dd HH:mm:ss"),
        DATETIME_MS("yyyy-MM-dd HH:mm:ss:SSS"),
        TIME("HH:mm:ss"),
        DATE_NO("yyyyMMdd"),
        DATETIME_NO("yyyyMMddHHmmss"),
        DATETIME_MS_NO("yyyyMMddHHmmssSSS"),
        TIME_NO("HHmmss"),
        TIME_MS_NO("HHmmssSSS"),
        YEAR("yyyy"),
        MONTH("MM"),
        DAY("dd"),
        YEAR_MONTH("yyyyMM");

        private String pattern;
        public static final Map<String, ThreadLocal<SimpleDateFormat>> map;

        public String format(Date date) {
            return map.get(this.getPattern()).get().format(date);
        }

        public Integer formatInt(Date date) {
            return Integer.valueOf(this.format(date));
        }

        public Date parse(String source) {
            try {
                return map.get(this.getPattern()).get().parse(source);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public Date parseOrReturnNow(String source) {
            Date date = this.parse(source);
            return date == null ? new Date() : date;
        }

        private DateFormat(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        static {
            map = new HashMap<String, ThreadLocal<SimpleDateFormat>>(13);
            for (DateFormat format : DateFormat.values()) {
                ThreadLocal<SimpleDateFormat> threadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat(format.getPattern()));
                map.put(format.getPattern(), threadLocal);
            }
        }
    }
}

