/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.core.util;

import cn.tuia.mango.core.enums.CodeDescriptionEnumerable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public abstract class EnumKit {
    private static Map<Class<?>, Map<?, ?>> enumConstantMap = new ConcurrentHashMap();

    public static <K, V, E extends Enum<E>> Optional<E> of(Class<E> enumClass, K enumCode) {
        Assert.notNull(enumClass, (String)"enumClass must not be null");
        Map<Object, Object> enumMap = enumConstantMap.get(enumClass);
        if (enumMap == null) {
            Map<Object, Enum> map = Arrays.stream(enumClass.getEnumConstants()).collect(Collectors.toMap(e -> ((CodeDescriptionEnumerable)((Object)e)).getCode(), e -> e));
            enumConstantMap.put(enumClass, map);
            enumMap = map;
        }
        return Optional.ofNullable((Enum)enumMap.get(enumCode));
    }

    public static <K, V, E extends Enum<E>> Optional<E> find(Class<E> enumClass, K enumCode) {
        Assert.notNull(enumClass, (String)"enumClass must not be null");
        return Arrays.stream(enumClass.getEnumConstants()).filter(e -> ((CodeDescriptionEnumerable)((Object)e)).getCode().equals(enumCode)).findAny();
    }
}

