/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.core.util;

import cn.tuia.mango.core.util.DateFormatKit;
import java.security.SecureRandom;
import java.util.Date;
import java.util.UUID;
import org.springframework.util.StringUtils;

public abstract class IdHelper {
    public static final String COLON = ":";
    private static final ThreadLocal<SecureRandom> randomHolder = ThreadLocal.withInitial(() -> new SecureRandom());

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uuid(String prefix) {
        if (StringUtils.hasText((String)prefix)) {
            return prefix + COLON + IdHelper.uuid();
        }
        return IdHelper.uuid();
    }

    public static String orderId() {
        return DateFormatKit.DateFormat.DATETIME_MS_NO.format(new Date()) + String.format("%03d", randomHolder.get().nextInt(999));
    }

    public static String orderId(String prefix) {
        if (StringUtils.hasText((String)prefix)) {
            return prefix + IdHelper.orderId();
        }
        return IdHelper.orderId();
    }
}

