package cn.tuia.mango.generator.mybatis.api;

import cn.tuia.mango.generator.mybatis.codegen.mybatis3.model.JavaEnumConfig;
import cn.tuia.mango.generator.mybatis.plugin.JavaServicePlugin;
import cn.tuia.mango.generator.mybatis.util.CollectionUtils;
import cn.tuia.mango.generator.mybatis.util.GeneratorUtils;
import org.mybatis.generator.api.VerboseProgressCallback;

import java.util.List;

/**
 * @author lijicong
 * @since 2020-04-06
 */
public class GeneratorProcessCallback extends VerboseProgressCallback {

    protected List<String> warnings;

    protected TemplateGenerator templateGenerator = TemplateGenerator.getInstance();

    public GeneratorProcessCallback(List<String> warnings) {
        super();
        this.warnings = warnings;
    }

    @Override
    public void done() {
        JavaEnumConfig javaEnumConfig = JavaServicePlugin.javaEnumConfig;
        javaEnumConfig.init();

        if (javaEnumConfig.isEnableEnum() && CollectionUtils.isNotEmpty(javaEnumConfig.getEnums())) {
            GeneratedSimpleFile javaFileConfig = new GeneratedSimpleFile(javaEnumConfig);
            if (!GeneratorUtils.exists(javaFileConfig)) {
                templateGenerator.clearGeneratedFile();
                templateGenerator.addGeneratedFile(javaFileConfig);
                templateGenerator.generate();
            } else {
                System.out.println("------------枚举文件已存在，打印枚举内容------------");
                System.out.println(javaFileConfig.getFormattedContent());
                warnings.add("------------枚举文件已存在，打印枚举内容------------");
                warnings.add(javaFileConfig.getFormattedContent());
            }
        }

    }
}
