package cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements;

import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

/**
 * @author lijicong
 * @since 2020-03-23
 */
public class SelectCountElementGenerator extends AbstractWhereConditionElementGenerator {
    @Override
    public void addElements(XmlElement parentElement) {
        XmlElement answer = new XmlElement("select");
        answer.addAttribute(new Attribute("id", "selectCount"));
        answer.addAttribute(new Attribute("resultType", "java.lang.Long"));

        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        answer.addAttribute(new Attribute("parameterType", parameterType.getFullyQualifiedName()));

        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from ");
        sb.append(introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime());
        answer.addElement(new TextElement(sb.toString()));

        addWhereConditionElement(answer);
        parentElement.addElement(answer);

    }
}
