/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.api;

import cn.tuia.mango.generator.mybatis.api.GeneratedSimpleFile;
import cn.tuia.mango.generator.mybatis.api.TemplateGenerator;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.model.JavaEnumConfig;
import cn.tuia.mango.generator.mybatis.plugin.JavaServicePlugin;
import cn.tuia.mango.generator.mybatis.util.CollectionUtils;
import cn.tuia.mango.generator.mybatis.util.GeneratorUtils;
import java.util.List;
import org.mybatis.generator.api.VerboseProgressCallback;

public class GeneratorProcessCallback
extends VerboseProgressCallback {
    protected List<String> warnings;
    protected TemplateGenerator templateGenerator = TemplateGenerator.getInstance();

    public GeneratorProcessCallback(List<String> warnings) {
        this.warnings = warnings;
    }

    public void done() {
        JavaEnumConfig javaEnumConfig = JavaServicePlugin.javaEnumConfig;
        javaEnumConfig.init();
        if (javaEnumConfig.isEnableEnum() && CollectionUtils.isNotEmpty(javaEnumConfig.getEnums())) {
            GeneratedSimpleFile javaFileConfig = new GeneratedSimpleFile(javaEnumConfig);
            if (!GeneratorUtils.exists(javaFileConfig)) {
                this.templateGenerator.clearGeneratedFile();
                this.templateGenerator.addGeneratedFile(javaFileConfig);
                this.templateGenerator.generate();
            } else {
                System.out.println("------------\u679a\u4e3e\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u6253\u5370\u679a\u4e3e\u5185\u5bb9------------");
                System.out.println(javaFileConfig.getFormattedContent());
                this.warnings.add("------------\u679a\u4e3e\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u6253\u5370\u679a\u4e3e\u5185\u5bb9------------");
                this.warnings.add(javaFileConfig.getFormattedContent());
            }
        }
    }
}

