/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.plugin;

import cn.tuia.mango.generator.mybatis.api.GeneratedTemplateFile;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.model.JavaEnumConfig;
import cn.tuia.mango.generator.mybatis.plugin.AbstractTemplatePlugin;
import cn.tuia.mango.generator.mybatis.util.JavaModelUtils;
import java.util.List;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class JavaServicePlugin
extends AbstractTemplatePlugin {
    protected boolean overwrite;
    protected boolean enableController;
    protected String controllerTargetProject;
    protected String controllerTargetPackage;
    protected boolean enableEnum;
    protected String enumTargetProject;
    protected String enumTargetPackage;
    public static JavaEnumConfig javaEnumConfig = new JavaEnumConfig();

    @Override
    public boolean validate(List<String> warnings) {
        if (StringUtility.isTrue((String)this.properties.getProperty("enableController"))) {
            this.enableController = true;
        }
        this.controllerTargetProject = StringUtility.stringHasValue((String)this.properties.getProperty("controllerTargetProject")) ? this.properties.getProperty("controllerTargetProject") : this.targetProject;
        if (StringUtility.stringHasValue((String)this.properties.getProperty("controllerTargetPackage"))) {
            this.controllerTargetPackage = this.properties.getProperty("controllerTargetPackage");
        }
        if (StringUtility.isTrue((String)this.properties.getProperty("enableEnum"))) {
            this.enableEnum = true;
        }
        this.enumTargetProject = StringUtility.stringHasValue((String)this.properties.getProperty("enumTargetProject")) ? this.properties.getProperty("enumTargetProject") : this.targetProject;
        if (StringUtility.stringHasValue((String)this.properties.getProperty("enumTargetPackage"))) {
            this.enumTargetPackage = this.properties.getProperty("enumTargetPackage");
        }
        return super.validate(warnings);
    }

    public void initialized(IntrospectedTable introspectedTable) {
        String domainSimpleName = JavaModelUtils.getDomainSimpleName(introspectedTable);
        introspectedTable.setAttribute("originalClassName", (Object)domainSimpleName);
        this.registerConfigMap("Service.java", introspectedTable);
        introspectedTable.setAttribute("templateName", (Object)"ServiceImpl.java");
        String servcieImplTargetProject = this.targetProject;
        String servcieImplTargetPackage = this.targetPackage + ".impl";
        GeneratedTemplateFile serviceImplFile = new GeneratedTemplateFile(servcieImplTargetProject, servcieImplTargetPackage, this.context, this.properties, introspectedTable);
        this.configMap.put("ServiceImpl.java", serviceImplFile);
        introspectedTable.setAttribute("templateName", (Object)"Mapper.java");
        String mapperTargetProject = introspectedTable.getContext().getJavaClientGeneratorConfiguration().getTargetProject();
        String mapperTargetPackage = introspectedTable.getContext().getJavaClientGeneratorConfiguration().getTargetPackage();
        GeneratedTemplateFile mapperConfig = new GeneratedTemplateFile(mapperTargetProject, mapperTargetPackage, this.context, this.properties, introspectedTable);
        this.configMap.put("Mapper.java", mapperConfig);
        introspectedTable.setAttribute("templateName", (Object)"MapperExt.xml");
        String xmlTargetProject = introspectedTable.getContext().getSqlMapGeneratorConfiguration().getTargetProject();
        String xmlTargetPackage = introspectedTable.getContext().getSqlMapGeneratorConfiguration().getTargetPackage();
        GeneratedTemplateFile xmlConfig = new GeneratedTemplateFile(xmlTargetProject, xmlTargetPackage, this.context, this.properties, introspectedTable);
        this.configMap.put("MapperExt.xml", xmlConfig);
        if (this.enableController) {
            introspectedTable.setAttribute("templateName", (Object)"Controller.java");
            String controllerTargetProject = this.targetProject;
            String controllerTargetPackage = this.controllerTargetPackage;
            GeneratedTemplateFile controllerConfig = new GeneratedTemplateFile(controllerTargetProject, controllerTargetPackage, this.context, this.properties, introspectedTable);
            this.configMap.put("Controller.java", controllerConfig);
        }
        this.templateGenerate();
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        javaEnumConfig.setTargetProject(this.targetProject);
        javaEnumConfig.setServiceTargetPackage(this.targetPackage);
        javaEnumConfig.setEnableEnum(this.enableEnum);
        javaEnumConfig.setTargetPackage(this.enumTargetPackage);
        for (IntrospectedColumn column : introspectedTable.getAllColumns()) {
            if (!StringUtility.stringHasValue((String)column.getRemarks()) || !column.getRemarks().contains(" ")) continue;
            javaEnumConfig.putIfAbsent(column.getJavaProperty(), column);
        }
        return null;
    }
}

