package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ActOrderRefundEntity
 * @projectName tuia-payment
 * @description: description
 * @date 2024.07.02 15:19
 */
@Getter
@Setter
@TableName("tb_act_order_refund")
public class ActOrderRefundEntity implements Serializable {

    private static final long serialVersionUID = 8462022254918249187L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 关联订单号
     */
    @TableField("order_no")
    private String orderNo;


    /**
     * 子业务单号
     */
    @TableField("biz_order_no")
    private String bizOrderNo;

    /**
     * 原退款金额
     */
    @TableField("original_amount")
    private Long originalAmount;

    /**
     * 实际退款金额
     */
    @TableField("amount")
    private Long amount;

    /**
     * 退款单号
     */
    @TableField("refund_order_no")
    private String refundOrderNo;

    /**
     * 退款状态
     */
    @TableField("refund_status")
    private Integer refundStatus;

    /**
     * 退款时间
     */
    @TableField("refund_time")
    private Date refundTime;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;

    /**
     * jimuId
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * ip
     */
    @TableField("ip")
    private String ip;
}

