package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_amount_record")
public class AmountRecordEntity implements Serializable {

    private static final long serialVersionUID = 4747030633614239160L;

    /**
     * 推啊订单id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 推啊订单id
     */
    @TableField("tuia_id")
    private String tuiaId;

    @TableField("jimu_id")
    private String jimuId;

    @TableField("schema_url")
    private String schemaUrl;


    @TableField("payment_channel")
    private Integer paymentChannel;

    /**
     * 发起方商户编号
     */
    @TableField("parent_merchant_no")
    private String parentMerchantNo;

    /**
     * 商品名
     */
    @TableField("goods_name")
    private String goodsName;

    /**
     * 商户号
     */
    @TableField("merchant_no")
    private String merchantNo;

    /**
     * 支付方式,WECHAT,ALIPAY
     */
    @TableField("pay_way")
    private String payWay;


    /**
     * 支付金额
     */
    @TableField("pay_amount")
    private Long payAmount;

    /**
     * 原始金额（未降价前）
     */
    @TableField("original_amount")
    private Long originalAmount;


    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;
    /**
     * 小程序id
     */
    @TableField("sp_app_id")
    private String spAppId;
    /**
     * 子商户号id
     */
    @TableField("sub_mch_id")
    private String subMchId;

    /**
     * 来源场景，正常1，返回拦截2，挽留3
     */
    @TableField("source_scene")
    private Integer sourceScene;

    /**
     * advertKey
     */
    @TableField("advert_key")
    private String advertKey;


}
