package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_bank_mer_batch_update_task_item")
public class BankMerBatchUpdateTaskItemEntity implements Serializable {

    private static final long serialVersionUID = 1026110031161880106L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 更新记录主表id
     */
    @TableField("task_id")
    private Long taskId;

    /**
     * 单条记录更新状态
     */
    @TableField("task_status")
    private Integer taskStatus;

    /**
     * 主商户id，和tb_pay_order表的merchant_no是一个字段
     */
    @TableField("mer_id")
    private String merId;

    /**
     * 子商户id（二级商户id），和tb_pay_order的bank_merchant_no是一个字段
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 子商户号之后投放时段
     */
    @TableField("bank_mer_post_period")
    private Integer bankMerPostPeriod;

    /**
     * 子商户号之后状态
     */
    @TableField("bank_mer_post_status")
    private Integer bankMerPostStatus;

    /**
     * 本次子商户更新结果
     */
    @TableField("msg")
    private String msg;
}