package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_bank_mer_time_period_releasing")
public class BankMerTimePeriodReleasingEntity implements Serializable {

    private static final long serialVersionUID = 1081253545398133934L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 日期
     */
    @TableField("date")
    private Date date;

    /**
     * 在投数量
     */
    @TableField("releasing_num")
    private Integer releasingNum;

    /**
     * 使用时段，运营维护，一天分为4个时段，1，2，3，4
     */
    @TableField("time_period")
    private Integer timePeriod;

    /**
     * 最近编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;
}