package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: MerchantUnionPayEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.07.23 18:03
 */
@Getter
@Setter
@TableName("tb_merchant_union_pay")
public class MerchantUnionPayEntity implements Serializable {
    private static final long serialVersionUID = -5377283062564479299L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 商户号
     */
    @TableField("mid")
    private String mid;

    /**
     * 终端号
     */
    @TableField("tid")
    private String tid;
}
