package cn.tuia.payment.api.enums;

import cn.tuia.payment.api.enums.ali.AlipayFundTransferStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author y.zhao
 * @title: ActOrderTransferStatusEnum
 * @projectName tuia-payment
 * @description: description
 * @date 2024.07.04 16:06
 */
@Getter
@AllArgsConstructor
public enum ActOrderTransferStatusEnum {


    INITIAL(0, "初始值"),
    ING(10, "转账中"),
    SUCCESS(20, "转账成功"),
    FAILED(30, "转账失败"),
    ;

    private final Integer code;
    private final String msg;


    /**
     * 根据 AlipayFundTransferStatusEnum 转换成 ActOrderTransferStatusEnum
     */
    public static ActOrderTransferStatusEnum convert(String aliStatusEnum) {
        if (Objects.isNull(aliStatusEnum)) {
            return null;
        }
        if (aliStatusEnum.equals(AlipayFundTransferStatusEnum.SUCCESS.getCode())) {
            return SUCCESS;
        } else if (aliStatusEnum.equals(AlipayFundTransferStatusEnum.FAIL.getCode()) || aliStatusEnum.equals(AlipayFundTransferStatusEnum.REFUND.getCode())) {
            return FAILED;
        }
        return ING;
    }

    /**
     * 是否 初始化
     */
    public static boolean ini(Integer status) {
        return Objects.nonNull(status) && status.equals(INITIAL.code);
    }

    /**
     * 是否转账成功
     */
    public static boolean success(Integer status) {
        return Objects.nonNull(status) && status.equals(SUCCESS.code);
    }

    /**
     * 是否转账失败
     */
    public static boolean failed(Integer status) {
        return Objects.nonNull(status) && status.equals(FAILED.code);
    }

    /**
     * 转账中
     */
    public static boolean ing(Integer status) {
        return Objects.nonNull(status) && status.equals(ING.code);
    }

}
