package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 子商户号状态
 * 联动、运营、巡查的状态都是这个
 *
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum BankMerStatusEnums {

    // 枚举值:
    //1-开启
    //2-关闭(暂停)
    //3-禁用
    //-1-其它

    NOT_AVAILABLE(-1, "不可用"),
    OFF(0, "关闭"),
    ON(1, "启用"),
    BANNED(2, "禁用"),
    ;
    private final Integer code;
    private final String name;
    public static final List<Integer> AVAILABLE_LIST = Arrays.asList(BankMerStatusEnums.ON.getCode());

    public static final List<Integer> NOT_AVAILABLE_LIST = Arrays.asList(BankMerStatusEnums.NOT_AVAILABLE.getCode(),
                                                                         BankMerStatusEnums.OFF.getCode(),
                                                                         BankMerStatusEnums.BANNED.getCode());

    public static final List<Integer> VALID_LIST = Arrays.asList(BankMerStatusEnums.NOT_AVAILABLE.getCode(),
                                                                 BankMerStatusEnums.OFF.getCode(),
                                                                 BankMerStatusEnums.ON.getCode(),
                                                                 BankMerStatusEnums.BANNED.getCode());

    /**
     * 是否是合法的枚举值
     */
    public static boolean isValid(Integer code) {
        return Objects.nonNull(code) && VALID_LIST.contains(code);
    }

    /**
     * 根据编码转名称
     */
    public static String trans2name(Integer code) {
        BankMerStatusEnums[] values = BankMerStatusEnums.values();
        for (BankMerStatusEnums one : values) {
            if (one.getCode().equals(code)) {
                return one.getName();
            }
        }
        return "";
    }

    /**
     * 根据名称转编码
     */
    public static Integer trans2Code(String name) {
        BankMerStatusEnums[] values = BankMerStatusEnums.values();
        for (BankMerStatusEnums one : values) {
            if (one.getName().equals(name)) {
                return one.getCode();
            }
        }
        return null;
    }

    /**
     * 如果子商户状态在这两种之内
     * 说明没在用
     */
    public static boolean notAvailable(Integer code) {
        return NOT_AVAILABLE_LIST.contains(code);
    }

    /**
     * 如果子商户状态不在这两种之内
     * 说明没在用
     */
    public static boolean available(Integer code) {
        return AVAILABLE_LIST.contains(code);
    }


}
