package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.ActOrderEntity;
import cn.tuia.payment.api.enums.ActOrderFlagEnum;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteActOrderService {
    /**
     * 根据userId查询所有订单信息
     *
     * @param userId
     * @return
     */
    List<ActOrderEntity> getByUserId(Long userId);

    boolean updateById(ActOrderEntity entity);
    boolean save(ActOrderEntity entity);

    /**
     * 根据 orderNo 查询订单信息（uk 唯一）
     *
     * @param orderNo
     * @return
     */
    ActOrderEntity getByOrderNo(String orderNo);

    /**
     * 查询所有已支付订单
     */
    List<ActOrderEntity> getPayedOrderList();

    /**
     * 根据活动标记查询数据
     *
     * @param actFlag
     * @return
     * @see ActOrderFlagEnum
     */
    List<ActOrderEntity> getByActFlag(Integer actFlag);
}
