package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.PaymentProductEntity;
import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author y.zhao
 * @title: PaymentProductDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2025.02.25 18:20
 */
@Data
public class PaymentProductDTO implements Serializable {
    private static final long serialVersionUID = -8731977297825195787L;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品描述
     */
    private String productDescription;

    /**
     * 积分
     */
    private Integer points;

    /**
     * 积分有效期
     */
    private Integer pointValid;

    /**
     * 产品兑换页
     */
    private String redemptionPage;

    /**
     * 领取限制
     */
    private String receivingLimit;

    /**
     * 非领取日跳转链接
     */
    private String nonReceivingDayRedirectUrl;

    /**
     * 非领取日文案
     */
    private String nonReceivingDayText;

    /**
     * 下单短信签名id
     */
    private String orderSmsSignatureId;

    /**
     * 下单短信模板id
     */
    private String orderSmsTemplateId;


    /**
     * 兑换验证码短信签名id
     */
    private String redemptionVerificationCodeSmsSignId;

    /**
     * 兑换验证码短信模板id
     */
    private String redemptionVerificationCodeSmsTemplateId;

    /**
     * 兑换短信签名id
     */
    private String redemptionSmsSignatureId;

    /**
     * 提交兑换短信模板id
     */
    private String submitRedemptionSmsTemplateId;

    /**
     * 兑换成功短信模板id
     */
    private String redemptionSuccessSmsTemplateId;

    /**
     * 兑换失败短信模板id
     */
    private String redemptionFailureSmsTemplateId;

    /**
     * 支付方 1-推啊 2-鼎煊
     */
    private Integer payer;

    /**
     * 产品模板 1-12期 2-0+12期
     */
    private Integer productTemplate;

    /**
     * 模板配置JSON
     * 示例: {"zeroPhasePoints": 1000, "twelvePhasePoints": 1000}
     */
    private String templateConfig;


    public static PaymentProductDTO toDTO(PaymentProductEntity entity) {
        if (Objects.isNull(entity)) {
            return new PaymentProductDTO();
        }
        PaymentProductDTO paymentProductDTO = JSON.parseObject(entity.getExtra(), PaymentProductDTO.class);
        if (paymentProductDTO == null) {
            paymentProductDTO = new PaymentProductDTO();
        }
        paymentProductDTO.setProductId(entity.getId());
        paymentProductDTO.setProductName(entity.getName());
        paymentProductDTO.setPoints(entity.getPoints());
        paymentProductDTO.setPointValid(entity.getPointValid());
        paymentProductDTO.setPayer(entity.getPayer());
        paymentProductDTO.setProductTemplate(entity.getProductTemplate());
        paymentProductDTO.setTemplateConfig(entity.getTemplateConfig());
        return paymentProductDTO;
    }

    public static PaymentProductEntity toEntity(PaymentProductDTO dto) {
        if (Objects.isNull(dto)) {
            return new PaymentProductEntity();
        }
        PaymentProductEntity entity = new PaymentProductEntity();
        entity.setId(dto.getProductId());
        entity.setName(dto.getProductName());
        entity.setPoints(dto.getPoints());
        entity.setPointValid(dto.getPointValid());
        entity.setPayer(dto.getPayer());
        entity.setProductTemplate(dto.getProductTemplate());
        entity.setTemplateConfig(dto.getTemplateConfig());
        entity.setExtra(JSON.toJSONString(dto));
        return entity;
    }
}
