package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 代扣退款记录表
 */
@Data
@TableName("tb_withhold_refund_record")
public class WithholdRefundRecordEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 代扣订单主表id
     */
    @TableField("withhold_id")
    private Long withholdId;

    /**
     * 推啊订单号
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 退款订单id
     */
    @TableField("refund_order_id")
    private String refundOrderId;

    /**
     * 退款金额
     */
    @TableField("refund_amount")
    private BigDecimal refundAmount;

    /**
     * 退款时间
     */
    @TableField("refund_time")
    private Date refundTime;

    /**
     * 清空的积分数
     */
    @TableField("clear_points")
    private Integer clearPoints;
}
