package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 补单表，订单完成支付后生成补单，插入该表，人工补单降低客诉率
 * 对应表：tb_replenish_order
 * @author lizhiheng
 */
@Data
@TableName("tb_replenish_order")
public class ReplenishOrderEntity implements Serializable {

    private static final long serialVersionUID = -7124690990296204126L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 商户池id
     */
    @TableField("pool_id")
    private Long poolId;

    /**
     * 支付渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 渠道状态
     */
    @TableField("channel_status")
    private Integer channelStatus;

    /**
     * 推啊状态
     */
    @TableField("tuia_status")
    private Integer tuiaStatus;

    /**
     * 商户号或者行业
     * merId或者industry
     */
    @TableField("type")
    private String type;

    /**
     * 子商户号
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 补单状态，未支付，支付中，已支付等
     */
    @TableField("replenish_order_status")
    private Integer replenishOrderStatus;

    /**
     * 订单id
     */
    @TableField("order_id")
    private String orderId;

    /**
     * 来源订单id
     */
    @TableField("source_order_id")
    private String sourceOrderId;

    /**
     * ip地址的行政编码，如：1101，只有4位
     */
    @TableField("ip_geo_code")
    private String ipGeoCode;
}