package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付方枚举
 */
@Getter
@AllArgsConstructor
public enum PayerEnum {

    TUIA(1, "推啊"),

    DINGXUAN(2, "鼎煊"),

    ;

    private final Integer code;
    private final String desc;

    public static String getDescByCode(Integer code) {
        for (PayerEnum e : PayerEnum.values()) {
            if (e.getCode().equals(code)) {
                return e.getDesc();
            }
        }
        return "";
    }

    public static boolean isValid(Integer code) {
        for (PayerEnum e : PayerEnum.values()) {
            if (e.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
