package cn.tuia.payment.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * 代扣订单状态枚举
 */
@Getter
public enum WithholdOrderStatusEnum {

    INIT(1, "初始化"),
    BINDCARD_SUCCESS(2, "绑卡成功"),
    PAY_SUCCESS(3, "支付成功"),
    PARTIAL_REFUND(4, "部分退款"),
    FULL_REFUND(5, "全额退款"),
    ;

    private final Integer code;
    private final String desc;

    WithholdOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static WithholdOrderStatusEnum getByCode(Integer code) {
        return Stream.of(WithholdOrderStatusEnum.values())
                .filter(e -> e.getCode().equals(code))
                .findFirst()
                .orElse(null);
    }
}
