package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 代扣明细表
 */
@Data
@TableName("tb_withhold_order_detail")
public class WithholdOrderDetailEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 代扣订单主表id
     */
    @TableField("withhold_id")
    private Long withholdId;

    /**
     * 推啊订单号
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 期数(0期、1期...12期)
     */
    @TableField("issue_time")
    private Integer issueTime;

    /**
     * 支付金额
     */
    @TableField("pay_amount")
    private BigDecimal payAmount;

    /**
     * 积分过期时间
     */
    @TableField("expire_time")
    private Date expireTime;

    /**
     * 状态 1-已支付 2-已发积分 3-已退款
     */
    @TableField("status")
    private Integer status;

    /**
     * 发放积分数
     */
    @TableField("points")
    private Integer points;

    /**
     * 支付时间
     */
    @TableField("pay_time")
    private Date payTime;
}
