package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum V2CallbackTypeEnum {


    CHANCE(1, "概率"),

    MANUAL(2, "手动"),

    ;

    private final Integer code;
    private final String desc;

    public static String convert2Name(Integer code) {
        for (V2CallbackTypeEnum v2CallbackTypeEnum : V2CallbackTypeEnum.values()) {
            if (v2CallbackTypeEnum.getCode().equals(code)) {
                return v2CallbackTypeEnum.getDesc();
            }
        }
        return "";
    }
}

















