package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.ConfigPageDTO;
import cn.tuia.payment.api.dto.req.ConfigPageQueryReq;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.PayOrderEntity;

/**
 * @author y.zhao
 * @title: RemoteConfigPageService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.23 13:49
 */
@AdvancedFeignClient
public interface RemoteConfigPageService {

    /**
     * 分页查询
     *
     * @param req
     * @return
     */
    ResultPage<ConfigPageDTO> page(ReqPageQuery<ConfigPageQueryReq> req);

    /**
     * 插入/更新
     *
     * @param dto
     * @return
     */
    Boolean upsert(ConfigPageDTO dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 根据jimuId查询配置信息
     *
     * @param jimuId
     * @return
     */
    ConfigPageDTO getByJimuId(String jimuId);

    ConfigPageDTO getById(Long id);

    /**
     * 执行退款配置
     *
     * @param payOrderEntity
     */
    void process4Refund(PayOrderEntity payOrderEntity);
}
