package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum SourceSceneEnum {
    ONE("正常", 1),
    TWO("返回拦截", 2),
    THREE("挽留", 3),
    CONFIRM("支付确认", 4),
    NO_ACTION_RETAIN("无行为挽留", 5),
    SMS_MARKETING("短信营销", 6),
    ;

    public static String convert2Name(Integer code) {
        for (SourceSceneEnum sourceSceneEnum : SourceSceneEnum.values()) {
            if (sourceSceneEnum.getCode().equals(code)) {
                return sourceSceneEnum.getMsg();
            }
        }
        return "";
    }

    private final String msg;
    private final Integer code;

}
