package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 代扣订单记录表
 */
@Data
@TableName("tb_withhold_order_record")
public class WithholdOrderRecordEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 推啊订单号
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 三方订单号
     */
    @TableField("third_order_id")
    private String thirdOrderId;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 身份证号
     */
    @TableField("idcard_number")
    private String idcardNumber;

    /**
     * 用户名
     */
    @TableField("user_name")
    private String userName;

    /**
     * 订单状态 1-初始化 2-绑卡成功 3-支付成功 4-部分退款 5-全额退款
     */
    @TableField("order_status")
    private Integer orderStatus;

    /**
     * 产品id
     */
    @TableField("product_id")
    private Long productId;

    /**
     * 页面id
     */
    @TableField("page_id")
    private String pageId;

    /**
     * 落地页url
     */
    @TableField("land_url")
    private String landUrl;

    /**
     * 绑卡时间
     */
    @TableField("binding_time")
    private Date bindingTime;

    /**
     * 首次支付时间
     */
    @TableField("pay_time")
    private Date payTime;

    /**
     * 累计支付金额
     */
    @TableField("total_pay_amount")
    private BigDecimal totalPayAmount = BigDecimal.ZERO;

    /**
     * 累计退款金额
     */
    @TableField("refund_amount")
    private BigDecimal refundAmount = BigDecimal.ZERO;
}
