explain SELECT 
    ri.PROV_CODE AS provinceCode,
    ri.CITY_CODE AS cityCode,
    ri.COUNTY_CODE AS countryCode,
    COUNT(IF(wu.subscribe = 1
            AND ri.APPROVAL_DATE <= NOW(),
        1,
        NULL)) AS saleNum,
    COUNT(IF(wu.subscribe = 1
            AND ri.APPROVAL_DATE < '2022-01-01 00:00:00',
        1,
        NULL)) AS saleResidue,
    COUNT(IF(wu.subscribe = 1
            AND ri.APPROVAL_DATE BETWEEN '2022-01-01 00:00:00' AND NOW()
            AND ri.INVITE_CODE NOT LIKE '8000%'
            AND ri.INVITE_CODE IS NOT NULL
            AND SOURCE IN (1 , 2, 5)
            AND ri.USER_ID IN (SELECT 
                fr.USER_ID
            FROM
                retailer_follow_record fr),
        1,
        NULL)) AS terminalInvite,
    COUNT(IF(wu.subscribe = 1
            AND ri.APPROVAL_DATE BETWEEN '2022-01-01 00:00:00' AND NOW()
            AND (ri.INVITE_CODE LIKE '8000%'
            OR ri.INVITE_CODE IS NULL)
            AND SOURCE IN (1 , 2, 5)
            AND ri.USER_ID IN (SELECT 
                fr.USER_ID
            FROM
                retailer_follow_record fr),
        1,
        NULL)) AS manageInvite,
    COUNT(IF(wu.subscribe = 1
            AND ri.APPROVAL_DATE BETWEEN '2022-01-01 00:00:00' AND NOW()
            AND ri.SOURCE NOT IN (1 , 2, 5),
        1,
        NULL)) AS activityEnter,
    COUNT(IF(wu.subscribe = 1
            AND ri.APPROVAL_DATE BETWEEN '2022-01-01 00:00:00' AND NOW()
            AND ri.SOURCE IN (1 , 2, 5)
            AND wu.ID NOT IN (SELECT 
                tri.USER_ID
            FROM
                retailer_info tri
                    INNER JOIN
                retailer_follow_record fr ON tri.USER_ID = fr.USER_ID
            WHERE
                tri.VERIFY_STATE = 1
                    AND tri.APPROVAL_DATE BETWEEN '2022-01-01 00:00:00' AND NOW()
                    AND fr.DEL_FLAG = 0
                    AND tri.DEL_FLAG = 0),
        1,
        NULL)) AS menuEnter
FROM
    wx_user wu
        INNER JOIN
    retailer_info ri ON wu.ID = ri.USER_ID
WHERE
    ri.PROV_NAME = '浙江省'
        AND ri.VERIFY_STATE = 1
        AND ri.DEL_FLAG = 0
        AND wu.DEL_FLAG = 0
GROUP BY ri.COUNTY_CODE