/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.client;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpClientConnectionManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApacheIdleConnectionCleaner
extends Thread {
    private static final Log LOG = LogFactory.getLog(ApacheIdleConnectionCleaner.class);
    private static final int PERIOD_SEC = 2;
    private static volatile ApacheIdleConnectionCleaner instance;
    private static final Map<HttpClientConnectionManager, Long> connMgrMap;
    private volatile boolean isShuttingDown;

    private ApacheIdleConnectionCleaner() {
        super("sdk-apache-idle-connection-cleaner");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerConnectionManager(HttpClientConnectionManager connMgr, Long idleTimeMills) {
        if (instance == null) {
            Class<ApacheIdleConnectionCleaner> clazz = ApacheIdleConnectionCleaner.class;
            // MONITORENTER : com.alibaba.cloudapi.sdk.client.ApacheIdleConnectionCleaner.class
            if (instance == null) {
                instance = new ApacheIdleConnectionCleaner();
                instance.start();
            }
            // MONITOREXIT : clazz
        }
        connMgrMap.put(connMgr, idleTimeMills);
    }

    public static void removeConnectionManager(HttpClientConnectionManager connectionManager) {
        connMgrMap.remove(connectionManager);
        if (connMgrMap.isEmpty()) {
            ApacheIdleConnectionCleaner.shutdown();
        }
    }

    public static void shutdown() {
        if (instance != null) {
            ApacheIdleConnectionCleaner.instance.isShuttingDown = true;
            instance.interrupt();
            connMgrMap.clear();
            instance = null;
        }
    }

    @Override
    public void run() {
        block5: while (true) {
            if (this.isShuttingDown) {
                LOG.debug((Object)"Shutting down.");
                return;
            }
            try {
                Thread.sleep(2000L);
                Iterator iterator = connMgrMap.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    Map.Entry entry = iterator.next();
                    try {
                        ((HttpClientConnectionManager)entry.getKey()).closeIdleConnections(((Long)entry.getValue()).longValue(), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception t) {
                        LOG.warn((Object)"close idle connections failed", (Throwable)t);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"interrupted.", (Throwable)e);
                continue;
            }
            catch (Throwable t) {
                LOG.warn((Object)"fatal error", t);
                continue;
            }
            break;
        }
    }

    static {
        connMgrMap = new ConcurrentHashMap();
    }
}

