/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.client;

import com.alibaba.cloudapi.sdk.client.BaseApiClient;
import com.alibaba.cloudapi.sdk.constant.SdkConstant;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.enums.WebSocketApiType;
import com.alibaba.cloudapi.sdk.enums.WebSocketConnectStatus;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiCallback;
import com.alibaba.cloudapi.sdk.model.ApiContext;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.ApiWebSocketListner;
import com.alibaba.cloudapi.sdk.model.WebSocketApiRequest;
import com.alibaba.cloudapi.sdk.model.WebSocketClientBuilderParams;
import com.alibaba.cloudapi.sdk.util.ApiRequestMaker;
import com.alibaba.cloudapi.sdk.util.CallbackManager;
import com.alibaba.cloudapi.sdk.util.HeartBeatManager;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import com.alibaba.cloudapi.sdk.util.ObjectReference;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.apache.commons.codec.binary.Base64;

public class WebSocketApiClient
extends BaseApiClient {
    final ObjectReference<WebSocket> webSocketRef = new ObjectReference();
    final ObjectReference<CountDownLatch> connectLatch = new ObjectReference();
    final ObjectReference<CountDownLatch> registerLatch = new ObjectReference();
    final ObjectReference<Boolean> registerCommandSuccess = new ObjectReference();
    final ObjectReference<String> errorMessage = new ObjectReference();
    private WebSocketApiClient instance;
    String websocketUrl;
    OkHttpClient client;
    Request connectRequest;
    ApiWebSocketListner apiWebSocketListner;
    AtomicInteger seq = new AtomicInteger(0);
    CallbackManager callbackManager;
    Thread callbackThread;
    WebSocketConnectStatus status = WebSocketConnectStatus.LOST_CONNECTION;
    WebSocketListener webSocketListener;
    HeartBeatManager heartBeatManager;
    Thread heartbeatThread;
    final int port = 8080;
    String deviceId;
    String connectionCredential = "";
    ApiRequest lastRegisterReqeust;
    ApiCallback lastRegisterCallback;
    boolean isRegister = false;
    int heartBeatInterval = 25000;
    Object connectionLock = new Object();

    protected String getDeviceId() {
        return this.deviceId;
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    public boolean isOnline() {
        return this.isRegister && this.status == WebSocketConnectStatus.CONNECTED;
    }

    protected WebSocketApiClient() {
    }

    protected void init(WebSocketClientBuilderParams params) {
        if (null == params) {
            throw new SdkException("WebSocketClientBuilderParams must not be null");
        }
        params.check();
        this.appKey = params.getAppKey();
        this.appSecret = params.getAppSecret();
        this.deviceId = this.generateDeviceSum();
        this.websocketUrl = Scheme.WEBSOCKET.getValue() + params.getHost();
        this.websocketUrl = this.websocketUrl + ":" + 8080;
        this.host = params.getHost();
        this.scheme = Scheme.WEBSOCKET;
        this.client = new OkHttpClient.Builder().readTimeout(params.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(params.getWriteTimeout(), TimeUnit.MILLISECONDS).connectTimeout(params.getConnectionTimeout(), TimeUnit.MILLISECONDS).build();
        this.connectRequest = new Request.Builder().url(this.websocketUrl).build();
        this.apiWebSocketListner = params.getApiWebSocketListner();
        this.callbackManager = new CallbackManager(params.getCallbackThreadPoolCount(), params.getRequestExpiredTime());
        this.callbackThread = new Thread((Runnable)this.callbackManager);
        this.callbackThread.start();
        this.connect();
        this.registerCommandSuccess.setObj((Object)false);
        this.errorMessage.setObj((Object)"");
        this.instance = this;
        this.isInit = true;
    }

    public WebSocketConnectStatus getStatus() {
        return this.status;
    }

    public void setStatus(WebSocketConnectStatus status) {
        this.status = status;
    }

    public void connect() {
        if (null == this.connectLatch.getObj()) {
            this.connectLatch.setObj((Object)new CountDownLatch(1));
        }
        if (null == this.webSocketListener) {
            this.webSocketListener = new /* Unavailable Anonymous Inner Class!! */;
        }
        this.client.newWebSocket(this.connectRequest, this.webSocketListener);
    }

    private void reSendRegister() {
        this.sendAsyncRequest(this.lastRegisterReqeust, this.lastRegisterCallback);
    }

    private void reconnect() {
        this.status = WebSocketConnectStatus.LOST_CONNECTION;
        if (null != this.heartBeatManager) {
            this.heartBeatManager.stop();
        }
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                this.connectLatch.setObj((Object)new CountDownLatch(1));
                if (null != this.heartBeatManager) {
                    this.heartBeatManager.stop();
                }
                if (null != this.webSocketRef.getObj()) {
                    Thread.sleep(1000L);
                    ((WebSocket)this.webSocketRef.getObj()).close(1000, "Reconnect");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected ApiResponse sendSyncRequest(ApiRequest apiRequest) {
        throw new SdkException("Not support sending sync request via websocket channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAsyncRequest(ApiRequest apiRequest, ApiCallback apiCallback) {
        this.checkIsInit();
        Object object = this.connectionLock;
        synchronized (object) {
            if (null != this.connectLatch.getObj() && ((CountDownLatch)this.connectLatch.getObj()).getCount() == 1L) {
                try {
                    ((CountDownLatch)this.connectLatch.getObj()).await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    throw new SdkException("WebSocket connect server failed ", (Throwable)ex);
                }
                finally {
                    this.connectLatch.setObj(null);
                }
            }
            if (this.status == WebSocketConnectStatus.LOST_CONNECTION) {
                apiCallback.onFailure(apiRequest, (Exception)new SdkException("WebSocket conection lost , connecting"));
                return;
            }
            if (WebSocketApiType.COMMON != apiRequest.getWebSocketApiType() && !this.preSendWebsocketCommandApi(apiRequest, apiCallback)) {
                return;
            }
            Integer seqNumber = this.seq.getAndIncrement();
            apiRequest.addHeader("x-ca-seq", seqNumber.toString());
            this.callbackManager.add(seqNumber, new ApiContext(apiCallback, apiRequest));
            String request = this.buildRequest(apiRequest);
            ((WebSocket)this.webSocketRef.getObj()).send(request);
        }
    }

    private boolean preSendWebsocketCommandApi(ApiRequest apiRequest, ApiCallback apiCallback) {
        if (WebSocketApiType.REGISTER == apiRequest.getWebSocketApiType()) {
            try {
                if (null != this.registerLatch.getObj() && !((CountDownLatch)this.registerLatch.getObj()).await(10L, TimeUnit.SECONDS)) {
                    Thread.sleep(5000L);
                    this.close();
                    apiCallback.onFailure(apiRequest, (Exception)new SdkException("WebSocket conection lost , connecting"));
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException ex) {
                throw new SdkException("WebSocket register failed ", (Throwable)ex);
            }
            finally {
                this.registerLatch.setObj(null);
            }
            if (!((Boolean)this.registerCommandSuccess.getObj()).booleanValue()) {
                apiCallback.onFailure(null, (Exception)new SdkException("Register Comand return error :" + (String)this.errorMessage.getObj()));
                return false;
            }
            this.lastRegisterReqeust = apiRequest.duplicate();
            this.lastRegisterCallback = apiCallback;
        }
        apiRequest.addHeader("x-ca-websocket_api_type", apiRequest.getWebSocketApiType().toString());
        return true;
    }

    private void postSendWebsocketCommandApi(WebSocketApiType type, ApiResponse response) {
        if (WebSocketApiType.REGISTER == type && 200 == response.getCode()) {
            this.isRegister = true;
        }
        if (WebSocketApiType.UNREGISTER == type) {
            if (null != this.heartBeatManager) {
                this.heartBeatManager.stop();
            }
            this.lastRegisterReqeust = null;
            this.lastRegisterCallback = null;
            this.isRegister = false;
        }
    }

    public void sendHeatbeart() {
        if (this.isInit && this.status == WebSocketConnectStatus.CONNECTED && this.webSocketRef.getObj() != null) {
            ((WebSocket)this.webSocketRef.getObj()).send("H1");
        }
    }

    private String generateDeviceSum() {
        return this.generateDeviceId() + "@" + this.appKey;
    }

    private String generateDeviceId() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    private String buildRequest(ApiRequest apiRequest) {
        apiRequest.setHost(this.host);
        apiRequest.setScheme(this.scheme);
        ApiRequestMaker.make((ApiRequest)apiRequest, (String)this.appKey, (String)this.appSecret);
        WebSocketApiRequest webSocketApiRequest = new WebSocketApiRequest();
        webSocketApiRequest.setHost(this.host);
        webSocketApiRequest.setPath(apiRequest.getPath());
        webSocketApiRequest.setMethod(apiRequest.getMethod().getValue());
        webSocketApiRequest.setQuerys(apiRequest.getQuerys());
        webSocketApiRequest.setHeaders(apiRequest.getHeaders());
        webSocketApiRequest.setIsBase64(apiRequest.isBase64BodyViaWebsocket() ? 1 : 0);
        MediaType bodyType = MediaType.parse((String)apiRequest.getFirstHeaderValue("content-type"));
        if (null != apiRequest.getFormParams() && apiRequest.getFormParams().size() > 0) {
            webSocketApiRequest.setBody(HttpCommonUtil.buildParamString((Map)apiRequest.getFormParams()));
        } else if (null != apiRequest.getBody()) {
            webSocketApiRequest.setBody(new String(apiRequest.getBody(), bodyType.charset(SdkConstant.CLOUDAPI_ENCODING)));
        }
        if (apiRequest.isBase64BodyViaWebsocket()) {
            webSocketApiRequest.setBody(Base64.encodeBase64String((byte[])apiRequest.getBody()));
        }
        return JSON.toJSONString((Object)webSocketApiRequest);
    }

    static /* synthetic */ void access$000(WebSocketApiClient x0) {
        x0.reSendRegister();
    }

    static /* synthetic */ void access$100(WebSocketApiClient x0) {
        x0.close();
    }

    static /* synthetic */ WebSocketApiClient access$200(WebSocketApiClient x0) {
        return x0.instance;
    }

    static /* synthetic */ void access$300(WebSocketApiClient x0, WebSocketApiType x1, ApiResponse x2) {
        x0.postSendWebsocketCommandApi(x1, x2);
    }

    static /* synthetic */ void access$400(WebSocketApiClient x0) {
        x0.reconnect();
    }
}

