/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.util;

import com.alibaba.cloudapi.sdk.constant.SdkConstant;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import com.alibaba.cloudapi.sdk.util.SignUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiRequestMaker {
    public static void make(ApiRequest request, String appKey, String appSecret) {
        Date current;
        request.setPath(ApiRequestMaker.combinePathParam((String)request.getPath(), (Map)request.getPathParams()));
        StringBuilder url = new StringBuilder().append(request.getScheme().getValue()).append(request.getHost()).append(request.getPath());
        if (null != request.getQuerys() && request.getQuerys().size() > 0) {
            url.append("?").append(HttpCommonUtil.buildParamString((Map)request.getQuerys()));
        }
        request.setUrl(url.toString());
        Date date = current = request.getCurrentDate() == null ? new Date() : request.getCurrentDate();
        if (null == request.getFirstHeaderValue("date")) {
            request.addHeader("date", ApiRequestMaker.getHttpDateHeaderValue((Date)current));
        }
        request.addHeader("x-ca-timestamp", String.valueOf(current.getTime()));
        request.addHeader("x-ca-nonce", UUID.randomUUID().toString());
        request.addHeader("user-agent", "ALIYUN-ANDROID-DEMO");
        request.addHeader("host", request.getHost());
        request.addHeader("x-ca-key", appKey);
        request.addHeader("CA_VERSION", "1");
        if (null == request.getFirstHeaderValue("content-type")) {
            request.addHeader("content-type", request.getMethod().getRequestContentType());
        }
        if (null == request.getFirstHeaderValue("accept")) {
            request.addHeader("accept", request.getMethod().getAcceptContentType());
        }
        if (!HttpCommonUtil.isEmpty((CharSequence)request.getSignatureMethod())) {
            request.addHeader("X-Ca-Signature-Method", request.getSignatureMethod());
        }
        if (null != request.getBody() && request.getBody().length > 0) {
            request.addHeader("content-md5", SignUtil.base64AndMD5((byte[])request.getBody()));
        }
        String signature = SignUtil.sign((ApiRequest)request, (String)appSecret);
        request.addHeader("x-ca-signature", signature);
        for (String key : request.getHeaders().keySet()) {
            List values = (List)request.getHeaders().get(key);
            if (null != values && values.size() > 0) {
                for (int i = 0; i < values.size(); ++i) {
                    byte[] temp = ((String)values.get(i)).getBytes(SdkConstant.CLOUDAPI_ENCODING);
                    values.set(i, new String(temp, SdkConstant.CLOUDAPI_HEADER_ENCODING));
                }
            }
            request.getHeaders().put(key, values);
        }
    }

    private static String combinePathParam(String path, Map<String, String> pathParams) {
        if (pathParams == null) {
            return path;
        }
        for (String key : pathParams.keySet()) {
            path = path.replace("[" + key + "]", pathParams.get(key));
        }
        return path;
    }

    private static String getHttpDateHeaderValue(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }
}

