/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.util;

import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiContext;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallbackManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog(CallbackManager.class);
    final int CHECK_EXPIRE_INTERVAL = 500;
    int requestExpiredTime = 10000;
    CountDownLatch countDownLatch = new CountDownLatch(1);
    ConcurrentHashMap<Integer, ApiContext> callbacks = new ConcurrentHashMap();
    static ExecutorService fixThreadPool;

    public CallbackManager(int callbackThreadPoolCount, int requestExpiredTimep) {
        this.requestExpiredTime = requestExpiredTimep;
        fixThreadPool = Executors.newFixedThreadPool(callbackThreadPoolCount);
    }

    public void add(Integer seq, ApiContext context) {
        this.callbacks.put(seq, context);
        if (this.countDownLatch != null && this.countDownLatch.getCount() == 1L) {
            this.countDownLatch.countDown();
        }
    }

    public ApiContext getContext(Integer seq) {
        return (ApiContext)this.callbacks.get(seq);
    }

    public void callback(int seq, ApiResponse response) {
        ApiContext apiContext = (ApiContext)this.callbacks.remove(seq);
        if (null != apiContext) {
            fixThreadPool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @Override
    public void run() {
        while (true) {
            Long current = new Date().getTime();
            ArrayList toBeRemove = new ArrayList();
            for (Map.Entry callback : this.callbacks.entrySet()) {
                ApiContext context = (ApiContext)callback.getValue();
                if (current - context.getStartTime() <= (long)this.requestExpiredTime) continue;
                context.getCallback().onFailure(context.getRequest(), (Exception)new SdkException("Get Response Timeout"));
                toBeRemove.add(callback.getKey());
            }
            for (Integer key : toBeRemove) {
                this.callbacks.remove(key);
            }
            try {
                if (this.callbacks.size() == 0) {
                    this.countDownLatch = new CountDownLatch(1);
                    this.countDownLatch.await();
                }
                Thread.sleep(500L);
                continue;
            }
            catch (Exception ex) {
                LOG.error((Object)"Check callback expired", (Throwable)ex);
                continue;
            }
            break;
        }
    }
}

