/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloudapi.sdk.util;

import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiHttpMessage;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.signature.ISignerFactory;
import com.alibaba.cloudapi.sdk.signature.ISinger;
import com.alibaba.cloudapi.sdk.signature.SignerFactoryManager;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignUtil {
    public static String sign(ApiRequest request, String secret) {
        try {
            String signString = SignUtil.buildStringToSign((ApiRequest)request);
            ISignerFactory signerFactory = SignerFactoryManager.findSignerFactory((String)request.getSignatureMethod());
            if (null == signerFactory) {
                throw new SdkException("unsupported signature method:" + request.getSignatureMethod());
            }
            ISinger signer = signerFactory.getSigner();
            if (null == signer) {
                throw new SdkException("Oops!");
            }
            try {
                return signer.sign(signString, secret);
            }
            catch (Exception e) {
                throw new SdkException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildStringToSign(ApiRequest apiRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append(apiRequest.getMethod().getValue()).append("\n");
        if (apiRequest.getFirstHeaderValue("accept") != null) {
            sb.append(apiRequest.getFirstHeaderValue("accept"));
        }
        sb.append("\n");
        if (apiRequest.getFirstHeaderValue("content-md5") != null) {
            sb.append(apiRequest.getFirstHeaderValue("content-md5"));
        }
        sb.append("\n");
        if (apiRequest.getFirstHeaderValue("content-type") != null) {
            sb.append(apiRequest.getFirstHeaderValue("content-type"));
        }
        sb.append("\n");
        if (apiRequest.getFirstHeaderValue("date") != null) {
            sb.append(apiRequest.getFirstHeaderValue("date"));
        }
        sb.append("\n");
        sb.append(SignUtil.buildHeaders((ApiHttpMessage)apiRequest));
        sb.append(SignUtil.buildResource((ApiRequest)apiRequest));
        return sb.toString();
    }

    public static String buildStringToSign(ApiResponse apiResponse) {
        StringBuilder sb = new StringBuilder();
        sb.append(apiResponse.getCode()).append("\n");
        String signatureHeaders = apiResponse.getFirstHeaderValue("x-ca-signature-headers");
        if (!HttpCommonUtil.isBlank((CharSequence)signatureHeaders)) {
            signatureHeaders = signatureHeaders.toLowerCase();
            String[] signatureHeaderList = signatureHeaders.split(",");
            for (int i = 0; i < signatureHeaderList.length; ++i) {
                if (apiResponse.getFirstHeaderValue(signatureHeaderList[i]) == null) continue;
                sb.append(apiResponse.getFirstHeaderValue(signatureHeaderList[i]));
                sb.append("\n");
            }
        }
        Map headers = apiResponse.getHeaders();
        for (String string : headers.keySet()) {
        }
        return sb.toString();
    }

    private static String buildResource(ApiRequest request) {
        StringBuilder result = new StringBuilder();
        result.append(request.getPath());
        TreeMap parameter = new TreeMap();
        if (null != request.getQuerys() && request.getQuerys().size() > 0) {
            parameter.putAll(request.getQuerys());
        }
        if (null != request.getFormParams() && request.getFormParams().size() > 0) {
            parameter.putAll(request.getFormParams());
        }
        if (parameter.size() > 0) {
            result.append("?");
            boolean isFirst = true;
            for (String key : parameter.keySet()) {
                if (!isFirst) {
                    result.append("&");
                } else {
                    isFirst = false;
                }
                result.append(key);
                String value = (String)parameter.get(key);
                if (null == value || "".equals(value)) continue;
                result.append("=").append(value);
            }
        }
        return result.toString();
    }

    private static String buildHeaders(ApiHttpMessage apiHttpMessage) {
        TreeMap headersToSign = new TreeMap();
        StringBuilder signHeadersStringBuilder = new StringBuilder();
        int flag = 0;
        for (Map.Entry header : apiHttpMessage.getHeaders().entrySet()) {
            if (!((String)header.getKey()).startsWith("x-ca-")) continue;
            if (flag != 0) {
                signHeadersStringBuilder.append(",");
            }
            ++flag;
            signHeadersStringBuilder.append((String)header.getKey());
            headersToSign.put(header.getKey(), apiHttpMessage.getFirstHeaderValue((String)header.getKey()));
        }
        apiHttpMessage.addHeader("x-ca-signature-headers", signHeadersStringBuilder.toString());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : headersToSign.entrySet()) {
            sb.append((String)e.getKey()).append(':').append((String)e.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static String base64AndMD5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes can not be null");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(bytes);
            byte[] md5Result = md.digest();
            String base64Result = Base64.encodeBase64String((byte[])md5Result);
            return base64Result.length() > 24 ? base64Result.substring(0, 23) : base64Result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm MD5");
        }
    }
}

