/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.JSONPathException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.FieldSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class JSONPath
implements JSONAware {
    private static ConcurrentMap<String, JSONPath> pathCache = new ConcurrentHashMap(128, 0.75f, 1);
    private final String path;
    private Segment[] segments;
    private boolean hasRefSegment;
    private SerializeConfig serializeConfig;
    private ParserConfig parserConfig;
    static final long SIZE = 5614464919154503228L;
    static final long LENGTH = -1580386065683472715L;

    public JSONPath(String path) {
        this(path, SerializeConfig.getGlobalInstance(), ParserConfig.getGlobalInstance());
    }

    public JSONPath(String path, SerializeConfig serializeConfig, ParserConfig parserConfig) {
        if (path == null || path.length() == 0) {
            throw new JSONPathException("json-path can not be null or empty");
        }
        this.path = path;
        this.serializeConfig = serializeConfig;
        this.parserConfig = parserConfig;
    }

    protected void init() {
        if (this.segments != null) {
            return;
        }
        if ("*".equals(this.path)) {
            this.segments = new Segment[]{WildCardSegment.instance};
        } else {
            JSONPathParser parser = new JSONPathParser(this.path);
            this.segments = parser.explain();
            this.hasRefSegment = JSONPathParser.access$000((JSONPathParser)parser);
        }
    }

    public Object eval(Object rootObject) {
        if (rootObject == null) {
            return null;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            Segment segment = this.segments[i];
            currentObject = segment.eval(this, rootObject, currentObject);
        }
        return currentObject;
    }

    public Object extract(DefaultJSONParser parser) {
        if (parser == null) {
            return null;
        }
        this.init();
        if (this.hasRefSegment) {
            Object root = parser.parse();
            return this.eval(root);
        }
        if (this.segments.length == 0) {
            return parser.parse();
        }
        Context context = null;
        for (int i = 0; i < this.segments.length; ++i) {
            boolean eval;
            boolean last;
            Segment segment = this.segments[i];
            boolean bl = last = i == this.segments.length - 1;
            if (context != null && context.object != null) {
                context.object = segment.eval(this, null, context.object);
                continue;
            }
            if (!last) {
                Segment nextSegment = this.segments[i + 1];
                eval = segment instanceof PropertySegment && PropertySegment.access$100((PropertySegment)((PropertySegment)segment)) && (nextSegment instanceof ArrayAccessSegment || nextSegment instanceof MultiIndexSegment || nextSegment instanceof MultiPropertySegment || nextSegment instanceof SizeSegment || nextSegment instanceof PropertySegment || nextSegment instanceof FilterSegment) ? true : (nextSegment instanceof ArrayAccessSegment && ArrayAccessSegment.access$200((ArrayAccessSegment)((ArrayAccessSegment)nextSegment)) < 0 ? true : (nextSegment instanceof FilterSegment ? true : segment instanceof WildCardSegment));
            } else {
                eval = true;
            }
            context = new Context(context, eval);
            segment.extract(this, parser, context);
        }
        return context.object;
    }

    public boolean contains(Object rootObject) {
        if (rootObject == null) {
            return false;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            Object parentObject = currentObject;
            if ((currentObject = this.segments[i].eval(this, rootObject, currentObject)) == null) {
                return false;
            }
            if (currentObject != Collections.EMPTY_LIST || !(parentObject instanceof List)) continue;
            return ((List)parentObject).contains(currentObject);
        }
        return true;
    }

    public boolean containsValue(Object rootObject, Object value) {
        Object currentObject = this.eval(rootObject);
        if (currentObject == value) {
            return true;
        }
        if (currentObject == null) {
            return false;
        }
        if (currentObject instanceof Iterable) {
            for (Object item : (Iterable)currentObject) {
                if (!JSONPath.eq(item, (Object)value)) continue;
                return true;
            }
            return false;
        }
        return JSONPath.eq((Object)currentObject, (Object)value);
    }

    public int size(Object rootObject) {
        if (rootObject == null) {
            return -1;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            currentObject = this.segments[i].eval(this, rootObject, currentObject);
        }
        return this.evalSize(currentObject);
    }

    public Set<?> keySet(Object rootObject) {
        if (rootObject == null) {
            return null;
        }
        this.init();
        Object currentObject = rootObject;
        for (int i = 0; i < this.segments.length; ++i) {
            currentObject = this.segments[i].eval(this, rootObject, currentObject);
        }
        return this.evalKeySet(currentObject);
    }

    public void arrayAdd(Object rootObject, Object ... values) {
        Object descArray;
        if (values == null || values.length == 0) {
            return;
        }
        if (rootObject == null) {
            return;
        }
        this.init();
        Object currentObject = rootObject;
        Object parentObject = null;
        for (int i = 0; i < this.segments.length; ++i) {
            if (i == this.segments.length - 1) {
                parentObject = currentObject;
            }
            currentObject = this.segments[i].eval(this, rootObject, currentObject);
        }
        Object result = currentObject;
        if (result == null) {
            throw new JSONPathException("value not found in path " + this.path);
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            for (Object value : values) {
                collection.add(value);
            }
            return;
        }
        Class<?> resultClass = result.getClass();
        if (resultClass.isArray()) {
            int length = Array.getLength(result);
            descArray = Array.newInstance(resultClass.getComponentType(), length + values.length);
            System.arraycopy(result, 0, descArray, 0, length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(descArray, length + i, values[i]);
            }
        } else {
            throw new JSONException("unsupported array put operation. " + resultClass);
        }
        Object newResult = descArray;
        Segment lastSegment = this.segments[this.segments.length - 1];
        if (lastSegment instanceof PropertySegment) {
            PropertySegment propertySegment = (PropertySegment)lastSegment;
            propertySegment.setValue(this, parentObject, newResult);
            return;
        }
        if (lastSegment instanceof ArrayAccessSegment) {
            ((ArrayAccessSegment)lastSegment).setValue(this, parentObject, newResult);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object rootObject) {
        if (rootObject == null) {
            return false;
        }
        this.init();
        Object currentObject = rootObject;
        Object parentObject = null;
        for (int i = 0; i < this.segments.length; ++i) {
            if (i == this.segments.length - 1) {
                parentObject = currentObject;
                break;
            }
            if ((currentObject = this.segments[i].eval(this, rootObject, currentObject)) == null) break;
        }
        if (parentObject == null) {
            return false;
        }
        Segment lastSegment = this.segments[this.segments.length - 1];
        if (lastSegment instanceof PropertySegment) {
            Segment parentSegment;
            PropertySegment propertySegment = (PropertySegment)lastSegment;
            if (parentObject instanceof Collection && this.segments.length > 1 && ((parentSegment = this.segments[this.segments.length - 2]) instanceof RangeSegment || parentSegment instanceof MultiIndexSegment)) {
                Collection collection = (Collection)parentObject;
                boolean removedOnce = false;
                for (Object item : collection) {
                    boolean removed = propertySegment.remove(this, item);
                    if (!removed) continue;
                    removedOnce = true;
                }
                return removedOnce;
            }
            return propertySegment.remove(this, parentObject);
        }
        if (lastSegment instanceof ArrayAccessSegment) {
            return ((ArrayAccessSegment)lastSegment).remove(this, parentObject);
        }
        throw new UnsupportedOperationException();
    }

    public boolean set(Object rootObject, Object value) {
        return this.set(rootObject, value, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean set(Object rootObject, Object value, boolean p) {
        if (rootObject == null) {
            return false;
        }
        this.init();
        Object currentObject = rootObject;
        Object parentObject = null;
        for (int i = 0; i < this.segments.length; ++i) {
            void var9_10;
            parentObject = currentObject;
            Segment segment = this.segments[i];
            if ((currentObject = segment.eval(this, rootObject, currentObject)) != null) continue;
            Segment nextSegment = null;
            if (i < this.segments.length - 1) {
                nextSegment = this.segments[i + 1];
            }
            Object var9_11 = null;
            if (nextSegment instanceof PropertySegment) {
                JavaBeanDeserializer beanDeserializer = null;
                Class fieldClass = null;
                if (segment instanceof PropertySegment) {
                    String propertyName = PropertySegment.access$300((PropertySegment)((PropertySegment)segment));
                    Class<?> parentClass = parentObject.getClass();
                    JavaBeanDeserializer parentBeanDeserializer = this.getJavaBeanDeserializer(parentClass);
                    if (parentBeanDeserializer != null) {
                        FieldDeserializer fieldDeserializer = parentBeanDeserializer.getFieldDeserializer(propertyName);
                        fieldClass = fieldDeserializer.fieldInfo.fieldClass;
                        beanDeserializer = this.getJavaBeanDeserializer(fieldClass);
                    }
                }
                if (beanDeserializer != null) {
                    if (beanDeserializer.beanInfo.defaultConstructor == null) return false;
                    Object object = beanDeserializer.createInstance(null, fieldClass);
                } else {
                    JSONObject jSONObject = new JSONObject();
                }
            } else if (nextSegment instanceof ArrayAccessSegment) {
                JSONArray jSONArray = new JSONArray();
            }
            if (var9_10 == null) break;
            if (segment instanceof PropertySegment) {
                PropertySegment propSegement = (PropertySegment)segment;
                propSegement.setValue(this, parentObject, (Object)var9_10);
                currentObject = var9_10;
                continue;
            }
            if (!(segment instanceof ArrayAccessSegment)) break;
            ArrayAccessSegment arrayAccessSegement = (ArrayAccessSegment)segment;
            arrayAccessSegement.setValue(this, parentObject, (Object)var9_10);
            currentObject = var9_10;
        }
        if (parentObject == null) {
            return false;
        }
        Segment lastSegment = this.segments[this.segments.length - 1];
        if (lastSegment instanceof PropertySegment) {
            PropertySegment propertySegment = (PropertySegment)lastSegment;
            propertySegment.setValue(this, parentObject, value);
            return true;
        }
        if (!(lastSegment instanceof ArrayAccessSegment)) throw new UnsupportedOperationException();
        return ((ArrayAccessSegment)lastSegment).setValue(this, parentObject, value);
    }

    public static Object eval(Object rootObject, String path) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        return jsonpath.eval(rootObject);
    }

    public static int size(Object rootObject, String path) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        Object result = jsonpath.eval(rootObject);
        return jsonpath.evalSize(result);
    }

    public static Set<?> keySet(Object rootObject, String path) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        Object result = jsonpath.eval(rootObject);
        return jsonpath.evalKeySet(result);
    }

    public static boolean contains(Object rootObject, String path) {
        if (rootObject == null) {
            return false;
        }
        JSONPath jsonpath = JSONPath.compile((String)path);
        return jsonpath.contains(rootObject);
    }

    public static boolean containsValue(Object rootObject, String path, Object value) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        return jsonpath.containsValue(rootObject, value);
    }

    public static void arrayAdd(Object rootObject, String path, Object ... values) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        jsonpath.arrayAdd(rootObject, values);
    }

    public static boolean set(Object rootObject, String path, Object value) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        return jsonpath.set(rootObject, value);
    }

    public static boolean remove(Object root, String path) {
        JSONPath jsonpath = JSONPath.compile((String)path);
        return jsonpath.remove(root);
    }

    public static JSONPath compile(String path) {
        if (path == null) {
            throw new JSONPathException("jsonpath can not be null");
        }
        JSONPath jsonpath = (JSONPath)pathCache.get(path);
        if (jsonpath == null) {
            jsonpath = new JSONPath(path);
            if (pathCache.size() < 1024) {
                pathCache.putIfAbsent(path, jsonpath);
                jsonpath = (JSONPath)pathCache.get(path);
            }
        }
        return jsonpath;
    }

    public static Object read(String json, String path) {
        return JSONPath.compile((String)path).eval(JSON.parse((String)json));
    }

    public static Object extract(String json, String path, ParserConfig config, int features, Feature ... optionFeatures) {
        DefaultJSONParser parser = new DefaultJSONParser(json, config, features |= Feature.OrderedField.mask);
        JSONPath jsonPath = JSONPath.compile((String)path);
        Object result = jsonPath.extract(parser);
        parser.lexer.close();
        return result;
    }

    public static Object extract(String json, String path) {
        return JSONPath.extract((String)json, (String)path, (ParserConfig)ParserConfig.global, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
    }

    public static Map<String, Object> paths(Object javaObject) {
        return JSONPath.paths((Object)javaObject, (SerializeConfig)SerializeConfig.globalInstance);
    }

    public static Map<String, Object> paths(Object javaObject, SerializeConfig config) {
        IdentityHashMap values = new IdentityHashMap();
        HashMap<String, Object> paths = new HashMap<String, Object>();
        JSONPath.paths(values, paths, (String)"/", (Object)javaObject, (SerializeConfig)config);
        return paths;
    }

    private static void paths(Map<Object, String> values, Map<String, Object> paths, String parent, Object javaObject, SerializeConfig config) {
        if (javaObject == null) {
            return;
        }
        String p = values.put(javaObject, parent);
        if (p != null) {
            boolean basicType;
            boolean bl = basicType = javaObject instanceof String || javaObject instanceof Number || javaObject instanceof Date || javaObject instanceof UUID;
            if (!basicType) {
                return;
            }
        }
        paths.put(parent, javaObject);
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            for (Map.Entry entryObj : map.entrySet()) {
                Map.Entry entry = entryObj;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String path = parent.equals("/") ? "/" + key : parent + "/" + key;
                JSONPath.paths(values, paths, (String)path, entry.getValue(), (SerializeConfig)config);
            }
            return;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            int i = 0;
            for (Object item : collection) {
                String path = parent.equals("/") ? "/" + i : parent + "/" + i;
                JSONPath.paths(values, paths, (String)path, item, (SerializeConfig)config);
                ++i;
            }
            return;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                String path = parent.equals("/") ? "/" + i : parent + "/" + i;
                JSONPath.paths(values, paths, (String)path, (Object)item, (SerializeConfig)config);
            }
            return;
        }
        if (ParserConfig.isPrimitive2(clazz) || clazz.isEnum()) {
            return;
        }
        ObjectSerializer serializer = config.getObjectWriter(clazz);
        if (serializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
            try {
                Map fieldValues = javaBeanSerializer.getFieldValuesMap(javaObject);
                for (Map.Entry entry : fieldValues.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!(key instanceof String)) continue;
                    String path = parent.equals("/") ? "/" + key : parent + "/" + key;
                    JSONPath.paths(values, paths, (String)path, entry.getValue(), (SerializeConfig)config);
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", (Throwable)e);
            }
            return;
        }
    }

    public String getPath() {
        return this.path;
    }

    static int compare(Object a, Object b) {
        if (a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        Class<?> typeA = a.getClass();
        Class<?> typeB = b.getClass();
        if (typeA == BigDecimal.class) {
            if (typeB == Integer.class) {
                b = new BigDecimal((Integer)b);
            } else if (typeB == Long.class) {
                b = new BigDecimal((Long)b);
            } else if (typeB == Float.class) {
                b = new BigDecimal(((Float)b).floatValue());
            } else if (typeB == Double.class) {
                b = new BigDecimal((Double)b);
            }
        } else if (typeA == Long.class) {
            if (typeB == Integer.class) {
                b = new Long(((Integer)b).intValue());
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((Long)a);
            } else if (typeB == Float.class) {
                a = new Float(((Long)a).longValue());
            } else if (typeB == Double.class) {
                a = new Double(((Long)a).longValue());
            }
        } else if (typeA == Integer.class) {
            if (typeB == Long.class) {
                a = new Long(((Integer)a).intValue());
            } else if (typeB == BigDecimal.class) {
                a = new BigDecimal((Integer)a);
            } else if (typeB == Float.class) {
                a = new Float(((Integer)a).intValue());
            } else if (typeB == Double.class) {
                a = new Double(((Integer)a).intValue());
            }
        } else if (typeA == Double.class) {
            if (typeB == Integer.class) {
                b = new Double(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = new Double(((Long)b).longValue());
            } else if (typeB == Float.class) {
                b = new Double(((Float)b).floatValue());
            }
        } else if (typeA == Float.class) {
            if (typeB == Integer.class) {
                b = new Float(((Integer)b).intValue());
            } else if (typeB == Long.class) {
                b = new Float(((Long)b).longValue());
            } else if (typeB == Double.class) {
                a = new Double(((Float)a).floatValue());
            }
        }
        return ((Comparable)a).compareTo(b);
    }

    protected Object getArrayItem(Object currentObject, int index) {
        if (currentObject == null) {
            return null;
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (index >= 0) {
                if (index < list.size()) {
                    return list.get(index);
                }
                return null;
            }
            if (Math.abs(index) <= list.size()) {
                return list.get(list.size() + index);
            }
            return null;
        }
        if (currentObject.getClass().isArray()) {
            int arrayLenth = Array.getLength(currentObject);
            if (index >= 0) {
                if (index < arrayLenth) {
                    return Array.get(currentObject, index);
                }
                return null;
            }
            if (Math.abs(index) <= arrayLenth) {
                return Array.get(currentObject, arrayLenth + index);
            }
            return null;
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            Object value = map.get(index);
            if (value == null) {
                value = map.get(Integer.toString(index));
            }
            return value;
        }
        if (currentObject instanceof Collection) {
            Collection collection = (Collection)currentObject;
            int i = 0;
            for (Object item : collection) {
                if (i == index) {
                    return item;
                }
                ++i;
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public boolean setArrayItem(JSONPath path, Object currentObject, int index, Object value) {
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (index >= 0) {
                list.set(index, value);
            } else {
                list.set(list.size() + index, value);
            }
            return true;
        }
        Class<?> clazz = currentObject.getClass();
        if (clazz.isArray()) {
            int arrayLenth = Array.getLength(currentObject);
            if (index >= 0) {
                if (index < arrayLenth) {
                    Array.set(currentObject, index, value);
                }
            } else if (Math.abs(index) <= arrayLenth) {
                Array.set(currentObject, arrayLenth + index, value);
            }
            return true;
        }
        throw new JSONPathException("unsupported set operation." + clazz);
    }

    public boolean removeArrayItem(JSONPath path, Object currentObject, int index) {
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (index >= 0) {
                if (index >= list.size()) {
                    return false;
                }
                list.remove(index);
            } else {
                int newIndex = list.size() + index;
                if (newIndex < 0) {
                    return false;
                }
                list.remove(newIndex);
            }
            return true;
        }
        Class<?> clazz = currentObject.getClass();
        throw new JSONPathException("unsupported set operation." + clazz);
    }

    protected Collection<Object> getPropertyValues(Object currentObject) {
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        if (beanSerializer != null) {
            try {
                return beanSerializer.getFieldValues(currentObject);
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path, (Throwable)e);
            }
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            return map.values();
        }
        if (currentObject instanceof Collection) {
            return (Collection)currentObject;
        }
        throw new UnsupportedOperationException();
    }

    protected void deepGetPropertyValues(Object currentObject, List<Object> outValues) {
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        Collection<Object> collection = null;
        if (beanSerializer != null) {
            try {
                collection = beanSerializer.getFieldValues(currentObject);
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path, (Throwable)e);
            }
        } else if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            collection = map.values();
        } else if (currentObject instanceof Collection) {
            collection = (Collection)currentObject;
        }
        if (collection != null) {
            for (Object fieldValue : collection) {
                if (fieldValue == null || ParserConfig.isPrimitive2(fieldValue.getClass())) {
                    outValues.add(fieldValue);
                    continue;
                }
                this.deepGetPropertyValues(fieldValue, outValues);
            }
            return;
        }
        throw new UnsupportedOperationException(currentClass.getName());
    }

    static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() == b.getClass()) {
            return a.equals(b);
        }
        if (a instanceof Number) {
            if (b instanceof Number) {
                return JSONPath.eqNotNull((Number)((Number)a), (Number)((Number)b));
            }
            return false;
        }
        return a.equals(b);
    }

    static boolean eqNotNull(Number a, Number b) {
        Class<?> clazzA = a.getClass();
        boolean isIntA = JSONPath.isInt(clazzA);
        Class<?> clazzB = b.getClass();
        boolean isIntB = JSONPath.isInt(clazzB);
        if (a instanceof BigDecimal) {
            BigDecimal decimalA = (BigDecimal)a;
            if (isIntB) {
                return decimalA.equals(BigDecimal.valueOf(TypeUtils.longExtractValue((Number)b)));
            }
        }
        if (isIntA) {
            if (isIntB) {
                return a.longValue() == b.longValue();
            }
            if (b instanceof BigInteger) {
                BigInteger bigIntB = (BigInteger)a;
                BigInteger bigIntA = BigInteger.valueOf(a.longValue());
                return bigIntA.equals(bigIntB);
            }
        }
        if (isIntB && a instanceof BigInteger) {
            BigInteger bigIntA = (BigInteger)a;
            BigInteger bigIntB = BigInteger.valueOf(TypeUtils.longExtractValue((Number)b));
            return bigIntA.equals(bigIntB);
        }
        boolean isDoubleA = JSONPath.isDouble(clazzA);
        boolean isDoubleB = JSONPath.isDouble(clazzB);
        if (isDoubleA && isDoubleB || isDoubleA && isIntB || isDoubleB && isIntA) {
            return a.doubleValue() == b.doubleValue();
        }
        return false;
    }

    protected static boolean isDouble(Class<?> clazzA) {
        return clazzA == Float.class || clazzA == Double.class;
    }

    protected static boolean isInt(Class<?> clazzA) {
        return clazzA == Byte.class || clazzA == Short.class || clazzA == Integer.class || clazzA == Long.class;
    }

    protected Object getPropertyValue(Object currentObject, String propertyName, long propertyNameHash) {
        if (currentObject == null) {
            return null;
        }
        if (currentObject instanceof String) {
            try {
                JSONObject object = JSON.parseObject((String)((String)currentObject));
                currentObject = object;
            }
            catch (Exception object) {
                // empty catch block
            }
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            Object val = map.get(propertyName);
            if (val == null && (5614464919154503228L == propertyNameHash || -1580386065683472715L == propertyNameHash)) {
                val = map.size();
            }
            return val;
        }
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        if (beanSerializer != null) {
            try {
                return beanSerializer.getFieldValue(currentObject, propertyName, propertyNameHash, false);
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + propertyName, (Throwable)e);
            }
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            if (5614464919154503228L == propertyNameHash || -1580386065683472715L == propertyNameHash) {
                return list.size();
            }
            JSONArray fieldValues = null;
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (obj == list) {
                    if (fieldValues == null) {
                        fieldValues = new JSONArray(list.size());
                    }
                    fieldValues.add(obj);
                    continue;
                }
                Object itemValue = this.getPropertyValue(obj, propertyName, propertyNameHash);
                if (itemValue instanceof Collection) {
                    Collection collection = (Collection)itemValue;
                    if (fieldValues == null) {
                        fieldValues = new JSONArray(list.size());
                    }
                    fieldValues.addAll(collection);
                    continue;
                }
                if (itemValue == null) continue;
                if (fieldValues == null) {
                    fieldValues = new JSONArray(list.size());
                }
                fieldValues.add(itemValue);
            }
            if (fieldValues == null) {
                fieldValues = Collections.emptyList();
            }
            return fieldValues;
        }
        if (currentObject instanceof Object[]) {
            Object[] array = (Object[])currentObject;
            if (5614464919154503228L == propertyNameHash || -1580386065683472715L == propertyNameHash) {
                return array.length;
            }
            JSONArray fieldValues = new JSONArray(array.length);
            for (int i = 0; i < array.length; ++i) {
                Object obj = array[i];
                if (obj == array) {
                    fieldValues.add(obj);
                    continue;
                }
                Object itemValue = this.getPropertyValue(obj, propertyName, propertyNameHash);
                if (itemValue instanceof Collection) {
                    Collection collection = (Collection)itemValue;
                    fieldValues.addAll(collection);
                    continue;
                }
                if (itemValue == null) continue;
                fieldValues.add(itemValue);
            }
            return fieldValues;
        }
        if (currentObject instanceof Enum) {
            long NAME = -4270347329889690746L;
            long ORDINAL = -1014497654951707614L;
            Enum e = (Enum)currentObject;
            if (-4270347329889690746L == propertyNameHash) {
                return e.name();
            }
            if (-1014497654951707614L == propertyNameHash) {
                return e.ordinal();
            }
        }
        if (currentObject instanceof Calendar) {
            long YEAR = 8963398325558730460L;
            long MONTH = -811277319855450459L;
            long DAY = -3851359326990528739L;
            long HOUR = 4647432019745535567L;
            long MINUTE = 6607618197526598121L;
            long SECOND = -6586085717218287427L;
            Calendar e = (Calendar)currentObject;
            if (8963398325558730460L == propertyNameHash) {
                return e.get(1);
            }
            if (-811277319855450459L == propertyNameHash) {
                return e.get(2);
            }
            if (-3851359326990528739L == propertyNameHash) {
                return e.get(5);
            }
            if (4647432019745535567L == propertyNameHash) {
                return e.get(11);
            }
            if (6607618197526598121L == propertyNameHash) {
                return e.get(12);
            }
            if (-6586085717218287427L == propertyNameHash) {
                return e.get(13);
            }
        }
        return null;
    }

    protected void deepScan(Object currentObject, String propertyName, List<Object> results) {
        if (currentObject == null) {
            return;
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            for (Map.Entry entry : map.entrySet()) {
                Object val = entry.getValue();
                if (propertyName.equals(entry.getKey())) {
                    if (val instanceof Collection) {
                        results.addAll((Collection)val);
                        continue;
                    }
                    results.add(val);
                    continue;
                }
                if (val == null || ParserConfig.isPrimitive2(val.getClass())) continue;
                this.deepScan(val, propertyName, results);
            }
            return;
        }
        if (currentObject instanceof Collection) {
            for (Object next : (Collection)currentObject) {
                if (ParserConfig.isPrimitive2(next.getClass())) continue;
                this.deepScan(next, propertyName, results);
            }
            return;
        }
        Class<?> currentClass = currentObject.getClass();
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
        if (beanSerializer != null) {
            try {
                FieldSerializer fieldDeser = beanSerializer.getFieldSerializer(propertyName);
                if (fieldDeser != null) {
                    try {
                        Object val = fieldDeser.getPropertyValueDirect(currentObject);
                        results.add(val);
                    }
                    catch (InvocationTargetException ex) {
                        throw new JSONException("getFieldValue error." + propertyName, (Throwable)ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new JSONException("getFieldValue error." + propertyName, (Throwable)ex);
                    }
                    return;
                }
                List fieldValues = beanSerializer.getFieldValues(currentObject);
                for (Object val : fieldValues) {
                    this.deepScan(val, propertyName, results);
                }
                return;
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + propertyName, (Throwable)e);
            }
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            for (int i = 0; i < list.size(); ++i) {
                Object val = list.get(i);
                this.deepScan(val, propertyName, results);
            }
            return;
        }
    }

    protected void deepSet(Object currentObject, String propertyName, long propertyNameHash, Object value) {
        if (currentObject == null) {
            return;
        }
        if (currentObject instanceof Map) {
            Map map = (Map)currentObject;
            if (map.containsKey(propertyName)) {
                Object val = map.get(propertyName);
                map.put(propertyName, value);
                return;
            }
            for (Object val : map.values()) {
                this.deepSet(val, propertyName, propertyNameHash, value);
            }
            return;
        }
        Class<?> currentClass = currentObject.getClass();
        JavaBeanDeserializer beanDeserializer = this.getJavaBeanDeserializer(currentClass);
        if (beanDeserializer != null) {
            try {
                FieldDeserializer fieldDeser = beanDeserializer.getFieldDeserializer(propertyName);
                if (fieldDeser != null) {
                    fieldDeser.setValue(currentObject, value);
                    return;
                }
                JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentClass);
                List fieldValues = beanSerializer.getObjectFieldValues(currentObject);
                for (Object val : fieldValues) {
                    this.deepSet(val, propertyName, propertyNameHash, value);
                }
                return;
            }
            catch (Exception e) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + propertyName, (Throwable)e);
            }
        }
        if (currentObject instanceof List) {
            List list = (List)currentObject;
            for (int i = 0; i < list.size(); ++i) {
                Object val = list.get(i);
                this.deepSet(val, propertyName, propertyNameHash, value);
            }
            return;
        }
    }

    protected boolean setPropertyValue(Object parent, String name, long propertyNameHash, Object value) {
        if (parent instanceof Map) {
            ((Map)parent).put(name, value);
            return true;
        }
        if (parent instanceof List) {
            for (Object element : (List)parent) {
                if (element == null) continue;
                this.setPropertyValue(element, name, propertyNameHash, value);
            }
            return true;
        }
        ObjectDeserializer deserializer = this.parserConfig.getDeserializer(parent.getClass());
        JavaBeanDeserializer beanDeserializer = null;
        if (deserializer instanceof JavaBeanDeserializer) {
            beanDeserializer = (JavaBeanDeserializer)deserializer;
        }
        if (beanDeserializer != null) {
            FieldDeserializer fieldDeserializer = beanDeserializer.getFieldDeserializer(propertyNameHash);
            if (fieldDeserializer == null) {
                return false;
            }
            fieldDeserializer.setValue(parent, value);
            return true;
        }
        throw new UnsupportedOperationException();
    }

    protected boolean removePropertyValue(Object parent, String name, boolean deep) {
        if (parent instanceof Map) {
            boolean found;
            Object origin = ((Map)parent).remove(name);
            boolean bl = found = origin != null;
            if (deep) {
                for (Object item : ((Map)parent).values()) {
                    this.removePropertyValue(item, name, deep);
                }
            }
            return found;
        }
        ObjectDeserializer deserializer = this.parserConfig.getDeserializer(parent.getClass());
        JavaBeanDeserializer beanDeserializer = null;
        if (deserializer instanceof JavaBeanDeserializer) {
            beanDeserializer = (JavaBeanDeserializer)deserializer;
        }
        if (beanDeserializer != null) {
            FieldDeserializer fieldDeserializer = beanDeserializer.getFieldDeserializer(name);
            boolean found = false;
            if (fieldDeserializer != null) {
                fieldDeserializer.setValue(parent, null);
                found = true;
            }
            if (deep) {
                Collection propertyValues = this.getPropertyValues(parent);
                for (Object item : propertyValues) {
                    if (item == null) continue;
                    this.removePropertyValue(item, name, deep);
                }
            }
            return found;
        }
        if (deep) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    protected JavaBeanSerializer getJavaBeanSerializer(Class<?> currentClass) {
        JavaBeanSerializer beanSerializer = null;
        ObjectSerializer serializer = this.serializeConfig.getObjectWriter(currentClass);
        if (serializer instanceof JavaBeanSerializer) {
            beanSerializer = (JavaBeanSerializer)serializer;
        }
        return beanSerializer;
    }

    protected JavaBeanDeserializer getJavaBeanDeserializer(Class<?> currentClass) {
        JavaBeanDeserializer beanDeserializer = null;
        ObjectDeserializer deserializer = this.parserConfig.getDeserializer(currentClass);
        if (deserializer instanceof JavaBeanDeserializer) {
            beanDeserializer = (JavaBeanDeserializer)deserializer;
        }
        return beanDeserializer;
    }

    int evalSize(Object currentObject) {
        if (currentObject == null) {
            return -1;
        }
        if (currentObject instanceof Collection) {
            return ((Collection)currentObject).size();
        }
        if (currentObject instanceof Object[]) {
            return ((Object[])currentObject).length;
        }
        if (currentObject.getClass().isArray()) {
            return Array.getLength(currentObject);
        }
        if (currentObject instanceof Map) {
            int count = 0;
            for (Object value : ((Map)currentObject).values()) {
                if (value == null) continue;
                ++count;
            }
            return count;
        }
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentObject.getClass());
        if (beanSerializer == null) {
            return -1;
        }
        try {
            return beanSerializer.getSize(currentObject);
        }
        catch (Exception e) {
            throw new JSONPathException("evalSize error : " + this.path, (Throwable)e);
        }
    }

    Set<?> evalKeySet(Object currentObject) {
        if (currentObject == null) {
            return null;
        }
        if (currentObject instanceof Map) {
            return ((Map)currentObject).keySet();
        }
        if (currentObject instanceof Collection || currentObject instanceof Object[] || currentObject.getClass().isArray()) {
            return null;
        }
        JavaBeanSerializer beanSerializer = this.getJavaBeanSerializer(currentObject.getClass());
        if (beanSerializer == null) {
            return null;
        }
        try {
            return beanSerializer.getFieldNames(currentObject);
        }
        catch (Exception e) {
            throw new JSONPathException("evalKeySet error : " + this.path, (Throwable)e);
        }
    }

    public String toJSONString() {
        return JSON.toJSONString((Object)this.path);
    }

    public static Object reserveToArray(Object object, String ... paths) {
        JSONArray reserved = new JSONArray();
        if (paths == null || paths.length == 0) {
            return reserved;
        }
        for (String item : paths) {
            JSONPath path = JSONPath.compile((String)item);
            path.init();
            Object value = path.eval(object);
            reserved.add(value);
        }
        return reserved;
    }

    public static Object reserveToObject(Object object, String ... paths) {
        if (paths == null || paths.length == 0) {
            return object;
        }
        JSONObject reserved = new JSONObject(true);
        for (String item : paths) {
            Object value;
            JSONPath path = JSONPath.compile((String)item);
            path.init();
            Segment lastSegement = path.segments[path.segments.length - 1];
            if (!(lastSegement instanceof PropertySegment) || (value = path.eval(object)) == null) continue;
            path.set((Object)reserved, value);
        }
        return reserved;
    }
}

