/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class JSONValidator
implements Cloneable {
    protected boolean eof;
    protected int pos = -1;
    protected char ch;
    protected Type type;
    protected int count = 0;
    protected boolean supportMultiValue = true;

    public static JSONValidator fromUtf8(byte[] jsonBytes) {
        return new UTF8Validator(jsonBytes);
    }

    public static JSONValidator fromUtf8(InputStream is) {
        return new UTF8InputStreamValidator(is);
    }

    public static JSONValidator from(String jsonStr) {
        return new UTF16Validator(jsonStr);
    }

    public static JSONValidator from(Reader r) {
        return new ReaderValidator(r);
    }

    public Type getType() {
        return this.type;
    }

    abstract void next();

    public boolean validate() {
        do {
            this.any();
            ++this.count;
            if (!this.supportMultiValue || this.eof) break;
            this.skipWhiteSpace();
        } while (!this.eof);
        return true;
    }

    public void close() throws IOException {
    }

    void any() {
        switch (this.ch) {
            case '{': {
                this.next();
                this.skipWhiteSpace();
                if (this.ch == '}') {
                    this.next();
                    this.type = Type.Object;
                    return;
                }
                while (true) {
                    if (this.ch == '\"') {
                        this.fieldName();
                    } else {
                        this.error();
                    }
                    this.skipWhiteSpace();
                    if (this.ch == ':') {
                        this.next();
                    } else {
                        this.error();
                    }
                    this.skipWhiteSpace();
                    this.any();
                    this.skipWhiteSpace();
                    if (this.ch == ',') {
                        this.next();
                        this.skipWhiteSpace();
                        continue;
                    }
                    if (this.ch == '}') break;
                }
                this.next();
                this.type = Type.Object;
                return;
            }
            case '[': {
                this.next();
                this.skipWhiteSpace();
                if (this.ch == ']') {
                    this.next();
                    this.type = Type.Array;
                    return;
                }
                while (true) {
                    this.any();
                    this.skipWhiteSpace();
                    if (this.ch == ',') {
                        this.next();
                        this.skipWhiteSpace();
                        continue;
                    }
                    if (this.ch == ']') {
                        this.next();
                        this.type = Type.Array;
                        return;
                    }
                    this.error();
                }
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.ch == '-' || this.ch == '+') {
                    this.next();
                    this.skipWhiteSpace();
                    if (this.ch < '0' || this.ch > '9') {
                        this.error();
                    }
                }
                do {
                    this.next();
                } while (this.ch >= '0' && this.ch <= '9');
                if (this.ch == '.') {
                    this.next();
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                if (this.ch == 'e' || this.ch == 'E') {
                    this.next();
                    if (this.ch == '-' || this.ch == '+') {
                        this.next();
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    } else {
                        this.error();
                    }
                    do {
                        this.next();
                    } while (this.ch >= '0' && this.ch <= '9');
                }
                this.type = Type.Value;
                break;
            }
            case '\"': {
                this.next();
                while (true) {
                    if (this.ch == '\\') {
                        this.next();
                        if (this.ch == 'u') {
                            this.next();
                            this.next();
                            this.next();
                            this.next();
                            this.next();
                            continue;
                        }
                        this.next();
                        continue;
                    }
                    if (this.ch == '\"') {
                        this.next();
                        this.type = Type.Value;
                        return;
                    }
                    this.next();
                }
            }
            case 't': {
                this.next();
                if (this.ch != 'r') {
                    this.error();
                }
                this.next();
                if (this.ch != 'u') {
                    this.error();
                }
                this.next();
                if (this.ch != 'e') {
                    this.error();
                }
                this.next();
                if (JSONValidator.isWhiteSpace((char)this.ch) || this.ch == ',' || this.ch == ']' || this.ch == '}' || this.ch == '\u0000') {
                    this.type = Type.Value;
                    return;
                }
                this.error();
            }
            case 'f': {
                this.next();
                if (this.ch != 'a') {
                    this.error();
                }
                this.next();
                if (this.ch != 'l') {
                    this.error();
                }
                this.next();
                if (this.ch != 's') {
                    this.error();
                }
                this.next();
                if (this.ch != 'e') {
                    this.error();
                }
                this.next();
                if (JSONValidator.isWhiteSpace((char)this.ch) || this.ch == ',' || this.ch == ']' || this.ch == '}' || this.ch == '\u0000') {
                    this.type = Type.Value;
                    return;
                }
                this.error();
            }
            case 'n': {
                this.next();
                if (this.ch != 'u') {
                    this.error();
                }
                this.next();
                if (this.ch != 'l') {
                    this.error();
                }
                this.next();
                if (this.ch != 'l') {
                    this.error();
                }
                this.next();
                if (JSONValidator.isWhiteSpace((char)this.ch) || this.ch == ',' || this.ch == ']' || this.ch == '}' || this.ch == '\u0000') {
                    this.type = Type.Value;
                    return;
                }
                this.error();
            }
            default: {
                this.error();
            }
        }
    }

    protected void fieldName() {
        this.next();
        while (true) {
            if (this.ch == '\\') {
                this.next();
                if (this.ch == 'u') {
                    this.next();
                    this.next();
                    this.next();
                    this.next();
                    this.next();
                    continue;
                }
                this.next();
                continue;
            }
            if (this.ch == '\"') break;
            this.next();
        }
        this.next();
    }

    void error() {
        throw new JSONException("error : " + this.pos);
    }

    void skipWhiteSpace() {
        while (JSONValidator.isWhiteSpace((char)this.ch)) {
            this.next();
        }
    }

    static final boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n' || ch == '\f' || ch == '\b';
    }
}

