/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.asm.ClassReader;
import com.alibaba.fastjson.asm.TypeCollector;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.alibaba.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.EnumDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JSONPDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.Jdk8DateCodec;
import com.alibaba.fastjson.parser.deserializer.MapDeserializer;
import com.alibaba.fastjson.parser.deserializer.NumberDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.OptionalCodec;
import com.alibaba.fastjson.parser.deserializer.PropertyProcessable;
import com.alibaba.fastjson.parser.deserializer.PropertyProcessableDeserializer;
import com.alibaba.fastjson.parser.deserializer.SqlDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.StackTraceElementDeserializer;
import com.alibaba.fastjson.parser.deserializer.ThrowableDeserializer;
import com.alibaba.fastjson.parser.deserializer.TimeDeserializer;
import com.alibaba.fastjson.serializer.AtomicCodec;
import com.alibaba.fastjson.serializer.AwtCodec;
import com.alibaba.fastjson.serializer.BigDecimalCodec;
import com.alibaba.fastjson.serializer.BigIntegerCodec;
import com.alibaba.fastjson.serializer.BooleanCodec;
import com.alibaba.fastjson.serializer.ByteBufferCodec;
import com.alibaba.fastjson.serializer.CalendarCodec;
import com.alibaba.fastjson.serializer.CharArrayCodec;
import com.alibaba.fastjson.serializer.CharacterCodec;
import com.alibaba.fastjson.serializer.CollectionCodec;
import com.alibaba.fastjson.serializer.DateCodec;
import com.alibaba.fastjson.serializer.FloatCodec;
import com.alibaba.fastjson.serializer.GuavaCodec;
import com.alibaba.fastjson.serializer.IntegerCodec;
import com.alibaba.fastjson.serializer.JodaCodec;
import com.alibaba.fastjson.serializer.LongCodec;
import com.alibaba.fastjson.serializer.MiscCodec;
import com.alibaba.fastjson.serializer.ObjectArrayCodec;
import com.alibaba.fastjson.serializer.ReferenceCodec;
import com.alibaba.fastjson.serializer.StringCodec;
import com.alibaba.fastjson.spi.Module;
import com.alibaba.fastjson.support.moneta.MonetaCodec;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.JavaBeanInfo;
import com.alibaba.fastjson.util.ServiceLoader;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParserConfig {
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String AUTOTYPE_ACCEPT = "fastjson.parser.autoTypeAccept";
    public static final String AUTOTYPE_SUPPORT_PROPERTY = "fastjson.parser.autoTypeSupport";
    public static final String[] DENYS;
    private static final String[] AUTO_TYPE_ACCEPT_LIST;
    public static final boolean AUTO_SUPPORT;
    public static ParserConfig global;
    private final IdentityHashMap<Type, ObjectDeserializer> deserializers = new IdentityHashMap();
    private final IdentityHashMap<Type, IdentityHashMap<Type, ObjectDeserializer>> mixInDeserializers = new IdentityHashMap(16);
    private final ConcurrentMap<String, Class<?>> typeMapping = new ConcurrentHashMap(16, 0.75f, 1);
    private boolean asmEnable = !ASMUtils.IS_ANDROID;
    public final SymbolTable symbolTable = new SymbolTable(4096);
    public PropertyNamingStrategy propertyNamingStrategy;
    protected ClassLoader defaultClassLoader;
    protected ASMDeserializerFactory asmFactory;
    private static boolean awtError;
    private static boolean jdk8Error;
    private static boolean jodaError;
    private static boolean guavaError;
    private boolean autoTypeSupport = AUTO_SUPPORT;
    private long[] denyHashCodes;
    private long[] acceptHashCodes;
    public final boolean fieldBased;
    private boolean jacksonCompatible = false;
    public boolean compatibleWithJavaBean = TypeUtils.compatibleWithJavaBean;
    private List<Module> modules = new ArrayList();

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this(false);
    }

    public ParserConfig(boolean fieldBase) {
        this(null, null, fieldBase);
    }

    public ParserConfig(ClassLoader parentClassLoader) {
        this(null, parentClassLoader, false);
    }

    public ParserConfig(ASMDeserializerFactory asmFactory) {
        this(asmFactory, null, false);
    }

    private ParserConfig(ASMDeserializerFactory asmFactory, ClassLoader parentClassLoader, boolean fieldBased) {
        this.denyHashCodes = new long[]{-8720046426850100497L, -8165637398350707645L, -8109300701639721088L, -8083514888460375884L, -7966123100503199569L, -7921218830998286408L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6179589609550493385L, -5194641081268104286L, -4837536971810737970L, -4082057040235125754L, -3935185854875733362L, -2753427844400776271L, -2364987994247679115L, -2262244760619952081L, -1872417015366588117L, -1589194880214235129L, -254670111376247151L, -190281065685395680L, 33238344207745342L, 313864100207897507L, 1073634739308289776L, 1203232727967308606L, 1459860845934817624L, 1502845958873959152L, 3547627781654598988L, 3688179072722109200L, 3730752432285826863L, 3794316665763266033L, 4147696707147271408L, 4904007817188630457L, 5100336081510080343L, 5347909877633654828L, 5450448828334921485L, 5688200883751798389L, 5751393439502795295L, 5944107969236155580L, 6456855723474196908L, 6742705432718011780L, 7017492163108594270L, 7179336928365889465L, 7442624256860549330L, 8389032537095247355L, 8409640769019589119L, 8537233257283452655L, 8838294710098435315L};
        long[] hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            hashCodes[i] = TypeUtils.fnv1a_64((String)AUTO_TYPE_ACCEPT_LIST[i]);
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.fieldBased = fieldBased;
        if (asmFactory == null && !ASMUtils.IS_ANDROID) {
            try {
                asmFactory = parentClassLoader == null ? new ASMDeserializerFactory((ClassLoader)new ASMClassLoader()) : new ASMDeserializerFactory(parentClassLoader);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (AccessControlException accessControlException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.asmFactory = asmFactory;
        if (asmFactory == null) {
            this.asmEnable = false;
        }
        this.initDeserializers();
        this.addItemsToDeny(DENYS);
        this.addItemsToAccept(AUTO_TYPE_ACCEPT_LIST);
    }

    private void initDeserializers() {
        this.deserializers.put(SimpleDateFormat.class, (Object)MiscCodec.instance);
        this.deserializers.put(Timestamp.class, (Object)SqlDateDeserializer.instance_timestamp);
        this.deserializers.put(java.sql.Date.class, (Object)SqlDateDeserializer.instance);
        this.deserializers.put(Time.class, (Object)TimeDeserializer.instance);
        this.deserializers.put(Date.class, (Object)DateCodec.instance);
        this.deserializers.put(Calendar.class, (Object)CalendarCodec.instance);
        this.deserializers.put(XMLGregorianCalendar.class, (Object)CalendarCodec.instance);
        this.deserializers.put(JSONObject.class, (Object)MapDeserializer.instance);
        this.deserializers.put(JSONArray.class, (Object)CollectionCodec.instance);
        this.deserializers.put(Map.class, (Object)MapDeserializer.instance);
        this.deserializers.put(HashMap.class, (Object)MapDeserializer.instance);
        this.deserializers.put(LinkedHashMap.class, (Object)MapDeserializer.instance);
        this.deserializers.put(TreeMap.class, (Object)MapDeserializer.instance);
        this.deserializers.put(ConcurrentMap.class, (Object)MapDeserializer.instance);
        this.deserializers.put(ConcurrentHashMap.class, (Object)MapDeserializer.instance);
        this.deserializers.put(Collection.class, (Object)CollectionCodec.instance);
        this.deserializers.put(List.class, (Object)CollectionCodec.instance);
        this.deserializers.put(ArrayList.class, (Object)CollectionCodec.instance);
        this.deserializers.put(Object.class, (Object)JavaObjectDeserializer.instance);
        this.deserializers.put(String.class, (Object)StringCodec.instance);
        this.deserializers.put(StringBuffer.class, (Object)StringCodec.instance);
        this.deserializers.put(StringBuilder.class, (Object)StringCodec.instance);
        this.deserializers.put(Character.TYPE, (Object)CharacterCodec.instance);
        this.deserializers.put(Character.class, (Object)CharacterCodec.instance);
        this.deserializers.put(Byte.TYPE, (Object)NumberDeserializer.instance);
        this.deserializers.put(Byte.class, (Object)NumberDeserializer.instance);
        this.deserializers.put(Short.TYPE, (Object)NumberDeserializer.instance);
        this.deserializers.put(Short.class, (Object)NumberDeserializer.instance);
        this.deserializers.put(Integer.TYPE, (Object)IntegerCodec.instance);
        this.deserializers.put(Integer.class, (Object)IntegerCodec.instance);
        this.deserializers.put(Long.TYPE, (Object)LongCodec.instance);
        this.deserializers.put(Long.class, (Object)LongCodec.instance);
        this.deserializers.put(BigInteger.class, (Object)BigIntegerCodec.instance);
        this.deserializers.put(BigDecimal.class, (Object)BigDecimalCodec.instance);
        this.deserializers.put(Float.TYPE, (Object)FloatCodec.instance);
        this.deserializers.put(Float.class, (Object)FloatCodec.instance);
        this.deserializers.put(Double.TYPE, (Object)NumberDeserializer.instance);
        this.deserializers.put(Double.class, (Object)NumberDeserializer.instance);
        this.deserializers.put(Boolean.TYPE, (Object)BooleanCodec.instance);
        this.deserializers.put(Boolean.class, (Object)BooleanCodec.instance);
        this.deserializers.put(Class.class, (Object)MiscCodec.instance);
        this.deserializers.put(char[].class, (Object)new CharArrayCodec());
        this.deserializers.put(AtomicBoolean.class, (Object)BooleanCodec.instance);
        this.deserializers.put(AtomicInteger.class, (Object)IntegerCodec.instance);
        this.deserializers.put(AtomicLong.class, (Object)LongCodec.instance);
        this.deserializers.put(AtomicReference.class, (Object)ReferenceCodec.instance);
        this.deserializers.put(WeakReference.class, (Object)ReferenceCodec.instance);
        this.deserializers.put(SoftReference.class, (Object)ReferenceCodec.instance);
        this.deserializers.put(UUID.class, (Object)MiscCodec.instance);
        this.deserializers.put(TimeZone.class, (Object)MiscCodec.instance);
        this.deserializers.put(Locale.class, (Object)MiscCodec.instance);
        this.deserializers.put(Currency.class, (Object)MiscCodec.instance);
        this.deserializers.put(Inet4Address.class, (Object)MiscCodec.instance);
        this.deserializers.put(Inet6Address.class, (Object)MiscCodec.instance);
        this.deserializers.put(InetSocketAddress.class, (Object)MiscCodec.instance);
        this.deserializers.put(File.class, (Object)MiscCodec.instance);
        this.deserializers.put(URI.class, (Object)MiscCodec.instance);
        this.deserializers.put(URL.class, (Object)MiscCodec.instance);
        this.deserializers.put(Pattern.class, (Object)MiscCodec.instance);
        this.deserializers.put(Charset.class, (Object)MiscCodec.instance);
        this.deserializers.put(JSONPath.class, (Object)MiscCodec.instance);
        this.deserializers.put(Number.class, (Object)NumberDeserializer.instance);
        this.deserializers.put(AtomicIntegerArray.class, (Object)AtomicCodec.instance);
        this.deserializers.put(AtomicLongArray.class, (Object)AtomicCodec.instance);
        this.deserializers.put(StackTraceElement.class, (Object)StackTraceElementDeserializer.instance);
        this.deserializers.put(Serializable.class, (Object)JavaObjectDeserializer.instance);
        this.deserializers.put(Cloneable.class, (Object)JavaObjectDeserializer.instance);
        this.deserializers.put(Comparable.class, (Object)JavaObjectDeserializer.instance);
        this.deserializers.put(Closeable.class, (Object)JavaObjectDeserializer.instance);
        this.deserializers.put(JSONPObject.class, (Object)new JSONPDeserializer());
    }

    private static String[] splitItemsFormProperty(String property) {
        if (property != null && property.length() > 0) {
            return property.split(",");
        }
        return null;
    }

    public void configFromPropety(Properties properties) {
        String property = properties.getProperty("fastjson.parser.deny");
        String[] items = ParserConfig.splitItemsFormProperty((String)property);
        this.addItemsToDeny(items);
        property = properties.getProperty("fastjson.parser.autoTypeAccept");
        items = ParserConfig.splitItemsFormProperty((String)property);
        this.addItemsToAccept(items);
        property = properties.getProperty("fastjson.parser.autoTypeSupport");
        if ("true".equals(property)) {
            this.autoTypeSupport = true;
        } else if ("false".equals(property)) {
            this.autoTypeSupport = false;
        }
    }

    private void addItemsToDeny(String[] items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            this.addDeny(item);
        }
    }

    private void addItemsToAccept(String[] items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            this.addAccept(item);
        }
    }

    public boolean isAutoTypeSupport() {
        return this.autoTypeSupport;
    }

    public void setAutoTypeSupport(boolean autoTypeSupport) {
        this.autoTypeSupport = autoTypeSupport;
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.deserializers;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        WildcardType wildcardType;
        Type[] upperBounds;
        ObjectDeserializer deserializer = this.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        if (type instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)type).getUpperBounds()).length == 1) {
            Type upperBoundType = upperBounds[0];
            return this.getDeserializer(upperBoundType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        String[] names;
        Class mappingTo;
        Object deserializer = this.get((Type)type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((deserializer = this.get(type)) != null) {
            return deserializer;
        }
        JSONType annotation = (JSONType)TypeUtils.getAnnotation(clazz, JSONType.class);
        if (annotation != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, (Type)mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            deserializer = this.get(clazz);
        }
        if (deserializer != null) {
            return deserializer;
        }
        for (Module module : this.modules) {
            deserializer = module.createDeserializer(this, clazz);
            if (deserializer == null) continue;
            this.putDeserializer(type, deserializer);
            return deserializer;
        }
        String className = clazz.getName();
        if ((className = className.replace('$', '.')).startsWith("java.awt.") && AwtCodec.support(clazz) && !awtError) {
            names = new String[]{"java.awt.Point", "java.awt.Font", "java.awt.Rectangle", "java.awt.Color"};
            try {
                for (String name : names) {
                    if (!name.equals(className)) continue;
                    deserializer = AwtCodec.instance;
                    this.putDeserializer(Class.forName(name), deserializer);
                    return deserializer;
                }
            }
            catch (Throwable e) {
                awtError = true;
            }
            deserializer = AwtCodec.instance;
        }
        if (!jdk8Error) {
            try {
                if (className.startsWith("java.time.")) {
                    for (String name : names = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZoneOffset", "java.time.ZoneRegion", "java.time.ZoneId", "java.time.Period", "java.time.Duration", "java.time.Instant"}) {
                        if (!name.equals(className)) continue;
                        deserializer = Jdk8DateCodec.instance;
                        this.putDeserializer(Class.forName(name), deserializer);
                        return deserializer;
                    }
                } else if (className.startsWith("java.util.Optional")) {
                    for (String name : names = new String[]{"java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong"}) {
                        if (!name.equals(className)) continue;
                        deserializer = OptionalCodec.instance;
                        this.putDeserializer(Class.forName(name), deserializer);
                        return deserializer;
                    }
                }
            }
            catch (Throwable e) {
                jdk8Error = true;
            }
        }
        if (!jodaError) {
            try {
                if (className.startsWith("org.joda.time.")) {
                    for (String name : names = new String[]{"org.joda.time.DateTime", "org.joda.time.LocalDate", "org.joda.time.LocalDateTime", "org.joda.time.LocalTime", "org.joda.time.Instant", "org.joda.time.Period", "org.joda.time.Duration", "org.joda.time.DateTimeZone", "org.joda.time.format.DateTimeFormatter"}) {
                        if (!name.equals(className)) continue;
                        deserializer = JodaCodec.instance;
                        this.putDeserializer(Class.forName(name), deserializer);
                        return deserializer;
                    }
                }
            }
            catch (Throwable e) {
                jodaError = true;
            }
        }
        if (!guavaError && className.startsWith("com.google.common.collect.")) {
            try {
                for (String name : names = new String[]{"com.google.common.collect.HashMultimap", "com.google.common.collect.LinkedListMultimap", "com.google.common.collect.LinkedHashMultimap", "com.google.common.collect.ArrayListMultimap", "com.google.common.collect.TreeMultimap"}) {
                    if (!name.equals(className)) continue;
                    deserializer = GuavaCodec.instance;
                    this.putDeserializer(Class.forName(name), deserializer);
                    return deserializer;
                }
            }
            catch (ClassNotFoundException e) {
                guavaError = true;
            }
        }
        if (className.equals("java.nio.ByteBuffer")) {
            deserializer = ByteBufferCodec.instance;
            this.putDeserializer(clazz, deserializer);
        }
        if (className.equals("java.nio.file.Path")) {
            deserializer = MiscCodec.instance;
            this.putDeserializer(clazz, deserializer);
        }
        if (clazz == Map.Entry.class) {
            deserializer = MiscCodec.instance;
            this.putDeserializer(clazz, deserializer);
        }
        if (className.equals("org.javamoney.moneta.Money")) {
            deserializer = MonetaCodec.instance;
            this.putDeserializer(clazz, deserializer);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AutowiredObjectDeserializer autowired : ServiceLoader.load(AutowiredObjectDeserializer.class, (ClassLoader)classLoader)) {
                for (Type forType : autowired.getAutowiredFor()) {
                    this.putDeserializer(forType, (ObjectDeserializer)autowired);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (deserializer == null) {
            deserializer = this.get(type);
        }
        if (deserializer != null) {
            return deserializer;
        }
        if (clazz.isEnum()) {
            if (this.jacksonCompatible) {
                Method[] methods;
                for (Method method : methods = clazz.getMethods()) {
                    if (!TypeUtils.isJacksonCreator((Method)method)) continue;
                    deserializer = this.createJavaBeanDeserializer(clazz, type);
                    this.putDeserializer(type, deserializer);
                    return deserializer;
                }
            }
            Class deserClass = null;
            JSONType jsonType = (JSONType)TypeUtils.getAnnotation(clazz, JSONType.class);
            if (jsonType != null) {
                deserClass = jsonType.deserializer();
                try {
                    deserializer = (ObjectDeserializer)deserClass.newInstance();
                    this.putDeserializer(clazz, deserializer);
                    return deserializer;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            deserializer = new EnumDeserializer(clazz);
        } else {
            deserializer = clazz.isArray() ? ObjectArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : (PropertyProcessable.class.isAssignableFrom(clazz) ? new PropertyProcessableDeserializer(clazz) : (clazz == InetAddress.class ? MiscCodec.instance : this.createJavaBeanDeserializer(clazz, type)))))));
        }
        this.putDeserializer(type, deserializer);
        return deserializer;
    }

    public void initJavaBeanDeserializers(Class<?> ... classes) {
        if (classes == null) {
            return;
        }
        for (Class<?> type : classes) {
            if (type == null) continue;
            ObjectDeserializer deserializer = this.createJavaBeanDeserializer(type, type);
            this.putDeserializer(type, deserializer);
        }
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        JavaBeanInfo beanInfo;
        boolean asmEnable = this.asmEnable & !this.fieldBased;
        if (asmEnable) {
            JSONType jsonType = (JSONType)TypeUtils.getAnnotation(clazz, JSONType.class);
            if (jsonType != null) {
                Class deserializerClass = jsonType.deserializer();
                if (deserializerClass != Void.class) {
                    try {
                        Object deseralizer = deserializerClass.newInstance();
                        if (deseralizer instanceof ObjectDeserializer) {
                            return (ObjectDeserializer)deseralizer;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                asmEnable = jsonType.asm();
            }
            if (asmEnable) {
                Class<?> superClass = JavaBeanInfo.getBuilderClass(clazz, (JSONType)jsonType);
                if (superClass == null) {
                    superClass = clazz;
                }
                do {
                    if (Modifier.isPublic(superClass.getModifiers())) continue;
                    asmEnable = false;
                    break;
                } while ((superClass = superClass.getSuperclass()) != Object.class && superClass != null);
            }
        }
        if (clazz.getTypeParameters().length != 0) {
            asmEnable = false;
        }
        if (asmEnable && this.asmFactory != null && this.asmFactory.classLoader.isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (asmEnable) {
            asmEnable = ASMUtils.checkName((String)clazz.getSimpleName());
        }
        if (asmEnable) {
            if (clazz.isInterface()) {
                asmEnable = false;
            }
            beanInfo = JavaBeanInfo.build(clazz, (Type)type, (PropertyNamingStrategy)this.propertyNamingStrategy, (boolean)false, (boolean)TypeUtils.compatibleWithJavaBean, (boolean)this.jacksonCompatible);
            if (asmEnable && beanInfo.fields.length > 200) {
                asmEnable = false;
            }
            Constructor defaultConstructor = beanInfo.defaultConstructor;
            if (asmEnable && defaultConstructor == null && !clazz.isInterface()) {
                asmEnable = false;
            }
            for (FieldInfo fieldInfo : beanInfo.fields) {
                ObjectDeserializer fieldDeser;
                if (fieldInfo.getOnly) {
                    asmEnable = false;
                    break;
                }
                Class fieldClass = fieldInfo.fieldClass;
                if (!Modifier.isPublic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldClass.isMemberClass() && !Modifier.isStatic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldInfo.getMember() != null && !ASMUtils.checkName((String)fieldInfo.getMember().getName())) {
                    asmEnable = false;
                    break;
                }
                JSONField annotation = fieldInfo.getAnnotation();
                if (annotation != null && (!ASMUtils.checkName((String)annotation.name()) || annotation.format().length() != 0 || annotation.deserializeUsing() != Void.class || annotation.unwrapped()) || fieldInfo.method != null && fieldInfo.method.getParameterTypes().length > 1) {
                    asmEnable = false;
                    break;
                }
                if (!fieldClass.isEnum() || (fieldDeser = this.getDeserializer((Type)fieldClass)) instanceof EnumDeserializer) continue;
                asmEnable = false;
                break;
            }
        }
        if (asmEnable && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (asmEnable && TypeUtils.isXmlField(clazz)) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        beanInfo = JavaBeanInfo.build(clazz, (Type)type, (PropertyNamingStrategy)this.propertyNamingStrategy);
        try {
            return this.asmFactory.createJavaBeanDeserializer(this, beanInfo);
        }
        catch (NoSuchMethodException ex) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (JSONException asmError) {
            return new JavaBeanDeserializer(this, beanInfo);
        }
        catch (Exception e) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), (Throwable)e);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, JavaBeanInfo beanInfo, FieldInfo fieldInfo) {
        Class clazz = beanInfo.clazz;
        Class fieldClass = fieldInfo.fieldClass;
        Class deserializeUsing = null;
        JSONField annotation = fieldInfo.getAnnotation();
        if (annotation != null && (deserializeUsing = annotation.deserializeUsing()) == Void.class) {
            deserializeUsing = null;
        }
        if (deserializeUsing == null && (fieldClass == List.class || fieldClass == ArrayList.class)) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        Type mixin = JSON.getMixInAnnotations((Type)type);
        if (mixin != null) {
            IdentityHashMap mixInClasses = (IdentityHashMap)this.mixInDeserializers.get((Object)type);
            if (mixInClasses == null) {
                mixInClasses = new IdentityHashMap(4);
                this.mixInDeserializers.put((Object)type, (Object)mixInClasses);
            }
            mixInClasses.put((Object)mixin, (Object)deserializer);
        } else {
            this.deserializers.put((Object)type, (Object)deserializer);
        }
    }

    public ObjectDeserializer get(Type type) {
        Type mixin = JSON.getMixInAnnotations((Type)type);
        if (null == mixin) {
            return (ObjectDeserializer)this.deserializers.get((Object)type);
        }
        IdentityHashMap mixInClasses = (IdentityHashMap)this.mixInDeserializers.get((Object)type);
        if (mixInClasses == null) {
            return null;
        }
        return (ObjectDeserializer)mixInClasses.get((Object)mixin);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.fieldClass, fieldInfo.fieldType);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return ParserConfig.isPrimitive2(clazz);
    }

    public static boolean isPrimitive2(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == java.sql.Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> fieldCacheMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldCacheMap.containsKey(fieldName)) continue;
            fieldCacheMap.put(fieldName, field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            ParserConfig.parserAllFieldToCache(clazz.getSuperclass(), fieldCacheMap);
        }
    }

    public static Field getFieldFromCache(String fieldName, Map<String, Field> fieldCacheMap) {
        Field field = fieldCacheMap.get(fieldName);
        if (field == null) {
            field = fieldCacheMap.get("_" + fieldName);
        }
        if (field == null) {
            field = fieldCacheMap.get("m_" + fieldName);
        }
        if (field == null) {
            char c0 = fieldName.charAt(0);
            if (c0 >= 'a' && c0 <= 'z') {
                char[] chars = fieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                String fieldNameX = new String(chars);
                field = fieldCacheMap.get(fieldNameX);
            }
            if (fieldName.length() > 2) {
                char c1 = fieldName.charAt(1);
                if (fieldName.length() > 2 && c0 >= 'a' && c0 <= 'z' && c1 >= 'A' && c1 <= 'Z') {
                    for (Map.Entry<String, Field> entry : fieldCacheMap.entrySet()) {
                        if (!fieldName.equalsIgnoreCase(entry.getKey())) continue;
                        field = entry.getValue();
                        break;
                    }
                }
            }
        }
        return field;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public void addDeny(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        long hash = TypeUtils.fnv1a_64((String)name);
        if (Arrays.binarySearch(this.denyHashCodes, hash) >= 0) {
            return;
        }
        long[] hashCodes = new long[this.denyHashCodes.length + 1];
        hashCodes[hashCodes.length - 1] = hash;
        System.arraycopy(this.denyHashCodes, 0, hashCodes, 0, this.denyHashCodes.length);
        Arrays.sort(hashCodes);
        this.denyHashCodes = hashCodes;
    }

    public void addAccept(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        long hash = TypeUtils.fnv1a_64((String)name);
        if (Arrays.binarySearch(this.acceptHashCodes, hash) >= 0) {
            return;
        }
        long[] hashCodes = new long[this.acceptHashCodes.length + 1];
        hashCodes[hashCodes.length - 1] = hash;
        System.arraycopy(this.acceptHashCodes, 0, hashCodes, 0, this.acceptHashCodes.length);
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
    }

    public Class<?> checkAutoType(Class type) {
        if (this.get((Type)type) != null) {
            return type;
        }
        return this.checkAutoType(type.getName(), null, JSON.DEFAULT_PARSER_FEATURE);
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass) {
        return this.checkAutoType(typeName, expectClass, JSON.DEFAULT_PARSER_FEATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Class<?> checkAutoType(String typeName, Class<?> expectClass, int features) {
        boolean autoTypeSupport;
        InputStream is;
        boolean jsonType;
        Class clazz;
        boolean expectClassFlag;
        block30: {
            int i;
            long hash;
            if (typeName == null) {
                return null;
            }
            if (typeName.length() >= 192 || typeName.length() < 3) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            expectClassFlag = expectClass == null ? false : expectClass != Object.class && expectClass != Serializable.class && expectClass != Cloneable.class && expectClass != Closeable.class && expectClass != EventListener.class && expectClass != Iterable.class && expectClass != Collection.class;
            String className = typeName.replace('$', '.');
            clazz = null;
            long BASIC = -3750763034362895579L;
            long PRIME = 1099511628211L;
            long h1 = (0xCBF29CE484222325L ^ (long)className.charAt(0)) * 1099511628211L;
            if (h1 == -5808493101479473382L) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if ((h1 ^ (long)className.charAt(className.length() - 1)) * 1099511628211L == 655701488918567152L) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            long h3 = (((0xCBF29CE484222325L ^ (long)className.charAt(0)) * 1099511628211L ^ (long)className.charAt(1)) * 1099511628211L ^ (long)className.charAt(2)) * 1099511628211L;
            if (this.autoTypeSupport || expectClassFlag) {
                hash = h3;
                for (i = 3; i < className.length(); ++i) {
                    hash ^= (long)className.charAt(i);
                    if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) >= 0 && (clazz = TypeUtils.loadClass((String)typeName, (ClassLoader)this.defaultClassLoader, (boolean)true)) != null) {
                        return clazz;
                    }
                    if (Arrays.binarySearch(this.denyHashCodes, hash) < 0 || TypeUtils.getClassFromMapping((String)typeName) != null) continue;
                    throw new JSONException("autoType is not support. " + typeName);
                }
            }
            if (clazz == null) {
                clazz = TypeUtils.getClassFromMapping((String)typeName);
            }
            if (clazz == null) {
                clazz = this.deserializers.findClass(typeName);
            }
            if (clazz == null) {
                clazz = (Class)this.typeMapping.get(typeName);
            }
            if (clazz != null) {
                if (expectClass != null && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                return clazz;
            }
            if (!this.autoTypeSupport) {
                hash = h3;
                for (i = 3; i < className.length(); ++i) {
                    char c = className.charAt(i);
                    hash ^= (long)c;
                    if (Arrays.binarySearch(this.denyHashCodes, hash *= 1099511628211L) >= 0) {
                        throw new JSONException("autoType is not support. " + typeName);
                    }
                    if (Arrays.binarySearch(this.acceptHashCodes, hash) < 0) continue;
                    if (clazz == null) {
                        clazz = TypeUtils.loadClass((String)typeName, (ClassLoader)this.defaultClassLoader, (boolean)true);
                    }
                    if (expectClass != null && expectClass.isAssignableFrom(clazz)) {
                        throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                    }
                    return clazz;
                }
            }
            jsonType = false;
            is = null;
            try {
                String resource = typeName.replace('.', '/') + ".class";
                is = this.defaultClassLoader != null ? this.defaultClassLoader.getResourceAsStream(resource) : ParserConfig.class.getClassLoader().getResourceAsStream(resource);
                if (is == null) break block30;
                ClassReader classReader = new ClassReader(is, true);
                TypeCollector visitor = new TypeCollector("<clinit>", new Class[0]);
                classReader.accept(visitor);
                jsonType = visitor.hasJsonType();
            }
            catch (Exception resource) {
                IOUtils.close(is);
                catch (Throwable throwable) {
                    IOUtils.close(is);
                    throw throwable;
                }
            }
        }
        IOUtils.close((Closeable)is);
        int mask = Feature.SupportAutoType.mask;
        boolean bl = autoTypeSupport = this.autoTypeSupport || (features & mask) != 0 || (JSON.DEFAULT_PARSER_FEATURE & mask) != 0;
        if (clazz == null && (autoTypeSupport || jsonType || expectClassFlag)) {
            boolean cacheClass = autoTypeSupport || jsonType;
            clazz = TypeUtils.loadClass((String)typeName, (ClassLoader)this.defaultClassLoader, (boolean)cacheClass);
        }
        if (clazz != null) {
            if (jsonType) {
                TypeUtils.addMapping((String)typeName, (Class)clazz);
                return clazz;
            }
            if (ClassLoader.class.isAssignableFrom(clazz) || DataSource.class.isAssignableFrom(clazz) || RowSet.class.isAssignableFrom(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    TypeUtils.addMapping((String)typeName, (Class)clazz);
                    return clazz;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            JavaBeanInfo beanInfo = JavaBeanInfo.build((Class)clazz, (Type)clazz, (PropertyNamingStrategy)this.propertyNamingStrategy);
            if (beanInfo.creatorConstructor != null && autoTypeSupport) {
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if (!autoTypeSupport) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (clazz != null) {
            TypeUtils.addMapping((String)typeName, (Class)clazz);
        }
        return clazz;
    }

    public void clearDeserializers() {
        this.deserializers.clear();
        this.initDeserializers();
    }

    public boolean isJacksonCompatible() {
        return this.jacksonCompatible;
    }

    public void setJacksonCompatible(boolean jacksonCompatible) {
        this.jacksonCompatible = jacksonCompatible;
    }

    public void register(String typeName, Class type) {
        this.typeMapping.putIfAbsent(typeName, type);
    }

    public void register(Module module) {
        this.modules.add(module);
    }

    static {
        String property = IOUtils.getStringProperty((String)"fastjson.parser.deny");
        DENYS = ParserConfig.splitItemsFormProperty((String)property);
        property = IOUtils.getStringProperty((String)"fastjson.parser.autoTypeSupport");
        AUTO_SUPPORT = "true".equals(property);
        property = IOUtils.getStringProperty((String)"fastjson.parser.autoTypeAccept");
        String[] items = ParserConfig.splitItemsFormProperty((String)property);
        if (items == null) {
            items = new String[]{};
        }
        AUTO_TYPE_ACCEPT_LIST = items;
        global = new ParserConfig();
        awtError = false;
        jdk8Error = false;
        jodaError = false;
        guavaError = false;
    }
}

