/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring.messaging;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import java.nio.charset.Charset;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class MappingFastJsonMessageConverter
extends AbstractMessageConverter {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public MappingFastJsonMessageConverter() {
        super(new MimeType("application", "json", Charset.forName("UTF-8")));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supports(targetClass);
    }

    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        return this.supports(payload.getClass());
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object payload = message.getPayload();
        Object obj = null;
        if (payload instanceof byte[]) {
            obj = JSON.parseObject((byte[])((byte[])payload), (Charset)this.fastJsonConfig.getCharset(), targetClass, (ParserConfig)this.fastJsonConfig.getParserConfig(), (ParseProcess)this.fastJsonConfig.getParseProcess(), (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])this.fastJsonConfig.getFeatures());
        } else if (payload instanceof String) {
            obj = JSON.parseObject((String)((String)payload), targetClass, (ParserConfig)this.fastJsonConfig.getParserConfig(), (ParseProcess)this.fastJsonConfig.getParseProcess(), (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])this.fastJsonConfig.getFeatures());
        }
        return obj;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        Object obj = byte[].class == this.getSerializedPayloadClass() ? (payload instanceof String && JSON.isValid((String)((String)payload)) ? (Object)((String)payload).getBytes(this.fastJsonConfig.getCharset()) : (Object)JSON.toJSONBytes((Charset)this.fastJsonConfig.getCharset(), (Object)payload, (SerializeConfig)this.fastJsonConfig.getSerializeConfig(), (SerializeFilter[])this.fastJsonConfig.getSerializeFilters(), (String)this.fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])this.fastJsonConfig.getSerializerFeatures())) : (payload instanceof String && JSON.isValid((String)((String)payload)) ? payload : JSON.toJSONString((Object)payload, (SerializeConfig)this.fastJsonConfig.getSerializeConfig(), (SerializeFilter[])this.fastJsonConfig.getSerializeFilters(), (String)this.fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])this.fastJsonConfig.getSerializerFeatures()));
        return obj;
    }
}

