/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.util.IdentityHashMap;
import java.util.Arrays;

public class IdentityHashMap<K, V> {
    private final Entry<K, V>[] buckets;
    private final int indexMask;
    public static final int DEFAULT_SIZE = 8192;

    public IdentityHashMap() {
        this(8192);
    }

    public IdentityHashMap(int tableSize) {
        this.indexMask = tableSize - 1;
        this.buckets = new Entry[tableSize];
    }

    public final V get(K key) {
        int hash = System.identityHashCode(key);
        int bucket = hash & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (key == entry.key) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Class findClass(String keyString) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry bucket = this.buckets[i];
            if (bucket == null) continue;
            Entry entry = bucket;
            while (entry != null) {
                Class clazz;
                String className;
                Object key = bucket.key;
                if (key instanceof Class && (className = (clazz = (Class)key).getName()).equals(keyString)) {
                    return clazz;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    public boolean put(K key, V value) {
        int hash = System.identityHashCode(key);
        int bucket = hash & this.indexMask;
        Entry entry = this.buckets[bucket];
        while (entry != null) {
            if (key == entry.key) {
                entry.value = value;
                return true;
            }
            entry = entry.next;
        }
        this.buckets[bucket] = entry = new Entry(key, value, hash, this.buckets[bucket]);
        return false;
    }

    public void clear() {
        Arrays.fill(this.buckets, null);
    }
}

