/*
 * Decompiled with CFR 0.152.
 */
package com.dataphin.jdbc;

import com.alibaba.cloudapi.sdk.client.ApacheHttpClient;
import com.alibaba.cloudapi.sdk.enums.HttpMethod;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.cloudapi.sdk.model.HttpClientBuilderParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dataphin.jdbc.Client;
import com.dataphin.jdbc.Utils;
import com.dataphin.jdbc.dto.OsInstance;
import com.dataphin.jdbc.dto.OsResult;
import com.dataphin.jdbc.dto.OsSession;
import com.dataphin.jdbc.dto.OsState;
import com.dataphin.jdbc.dto.ResultDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClient
extends ApacheHttpClient
implements Client {
    private static final int HTTP_SUCCESS_CODE = 200;
    private static final int HTTP_CONNECTION_ERROR_CODE = 400;
    private static final String ERROR_CODE_KEY = "errorCode";
    private static final String DATA_KEY = "data";
    private static final String SUCCESS_CODE = "success";
    private static final Logger logger = LoggerFactory.getLogger(ApiClient.class);
    private String url;
    private String database;
    private String accountId;
    private Map<String, String> properties;
    private String sessionId;
    private String instanceId;

    ApiClient(String url, Properties info) {
        this.url = url;
        this.database = Utils.getDB((String)url);
        this.accountId = info.getProperty("user");
        HttpClientBuilderParams params = new HttpClientBuilderParams();
        params.setAppKey(info.getProperty("user"));
        params.setAppSecret(info.getProperty("password"));
        params.setHost(Utils.getHost((String)url));
        params.setScheme(Scheme.HTTP);
        this.properties = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            this.properties.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        super.init(params);
    }

    public ResultDTO<OsSession> connect() throws SQLException {
        HashMap params = Maps.newHashMap();
        params.put("dataBase", this.database);
        String path = Utils.buildPath((String[])new String[]{"/connection", this.accountId});
        logger.info("connect: " + path);
        ApiResponse apiResponse = this.sendSyncRequest(this.buildApiRequest(path, this.properties, (Map)params));
        logger.info("connect response: ");
        ResultDTO result = this.buildResult(OsSession.class, apiResponse);
        Utils.checkResult((ResultDTO)result, (String)"connect");
        this.sessionId = ((OsSession)result.getData()).getSessionId();
        return result;
    }

    public void closeSession() throws SQLException {
        String path = Utils.buildPath((String[])new String[]{"/closeConnect", this.accountId, this.sessionId});
        logger.info("close session: " + path);
        ApiResponse apiResponse = this.sendSyncRequest(this.buildApiRequest(path));
        logger.info("close session response: ");
        ResultDTO result = this.buildResult(Void.class, apiResponse);
        Utils.checkResult((ResultDTO)result, (String)"close session");
    }

    public ResultDTO<OsResult> execute(OsInstance osInstance) throws SQLException {
        if (osInstance.getSql().equalsIgnoreCase("SELECT  CURRENT_DATABASE()")) {
            OsResult osResult = OsResult.builder().columns((List)Lists.newArrayList((Object[])new String[]{"TABLE_CATALOG", "TABLE_SCHEM"})).columnType((List)Lists.newArrayList((Object[])new String[]{"string", "string"})).build();
        }
        String path = Utils.buildPath((String[])new String[]{"/query", this.accountId, this.sessionId});
        logger.info("execute: " + path);
        logger.info(JSONObject.toJSONString((Object)osInstance));
        ApiResponse apiResponse = this.sendSyncRequest(this.buildApiRequest(path, osInstance));
        logger.info("execute response: ");
        ResultDTO result = this.buildResult(OsResult.class, apiResponse);
        Utils.checkResult((ResultDTO)result, (String)"execute");
        this.instanceId = ((OsResult)result.getData()).getInstanceId();
        return result;
    }

    public ResultDTO<OsState> state() throws SQLException {
        String path = Utils.buildPath((String[])new String[]{"/state", this.accountId, this.sessionId, this.instanceId});
        logger.info("state: " + path);
        ApiResponse apiResponse = this.sendSyncRequest(this.buildApiRequest(path));
        logger.info("state response: ");
        ResultDTO result = this.buildResult(OsState.class, apiResponse);
        Utils.checkResult((ResultDTO)result, (String)"state");
        return result;
    }

    public ResultDTO<OsResult> next() throws SQLException {
        String path = Utils.buildPath((String[])new String[]{"/next", this.accountId, this.sessionId, this.instanceId});
        logger.info("next: " + path);
        ApiResponse apiResponse = this.sendSyncRequest(this.buildApiRequest(path));
        logger.info("next response: ");
        ResultDTO result = this.buildResult(OsResult.class, apiResponse);
        Utils.checkResult((ResultDTO)result, (String)"next");
        return result;
    }

    public void closeStatement() throws SQLException {
        String path = Utils.buildPath((String[])new String[]{"/closeStatement", this.accountId, this.sessionId, this.instanceId});
        logger.info("close statement: " + path);
        ApiResponse apiResponse = this.sendSyncRequest(this.buildApiRequest(path));
        logger.info("close statement response:");
        ResultDTO result = this.buildResult(Void.class, apiResponse);
        Utils.checkResult((ResultDTO)result, (String)"close statement");
    }

    private ApiRequest buildApiRequest(String path, Map<String, String> body, Map<String, String> params) {
        String jsonStr = JSONObject.toJSONString(body);
        ApiRequest request = new ApiRequest(HttpMethod.POST_BODY, path, jsonStr.getBytes());
        request.setQuerys(params);
        return request;
    }

    private ApiRequest buildApiRequest(String path, OsInstance body) {
        String jsonStr = JSONObject.toJSONString((Object)body);
        return new ApiRequest(HttpMethod.POST_BODY, path, jsonStr.getBytes());
    }

    private ApiRequest buildApiRequest(String path) {
        return new ApiRequest(HttpMethod.GET, path);
    }

    private <T> ResultDTO<T> buildResult(Class<T> type, ApiResponse apiResponse) throws SQLException {
        String body = new String(apiResponse.getBody());
        logger.info("body: " + body);
        if (apiResponse.getCode() == 400) {
            throw new SQLException("connect error, check your network or does the URL match the username and password");
        }
        if (apiResponse.getCode() != 200) {
            throw new SQLException(body);
        }
        return (ResultDTO)JSON.parseObject((String)body, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabase() {
        return this.database;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

