/*
 * Decompiled with CFR 0.152.
 */
package com.dataphin.jdbc;

import com.dataphin.jdbc.OsConnection;
import com.dataphin.jdbc.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Driver
implements java.sql.Driver {
    private static final String URL_PREFIX = "jdbc:dataphin://";
    private static final boolean JDBC_COMPLIANT = false;
    private static final String DBNAME_PROPERTY_KEY = "DBNAME";
    private static final String HOST_PROPERTY_KEY = "HOST";
    private static final String PORT_PROPERTY_KEY = "PORT";
    private static final String USER_ID_KEY = "user_id";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? new OsConnection(url, this.parseUrlforPropertyInfo(url, info)) : null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches("jdbc:dataphin://.*", url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && url.startsWith(URL_PREFIX)) {
            info = this.parseUrlforPropertyInfo(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY, ""));
        hostProp.required = false;
        hostProp.description = "Hostname of Dataphin JDBC Server";
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, ""));
        portProp.required = false;
        portProp.description = "Port number of Dataphin JDBC Server";
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DBNAME_PROPERTY_KEY, info.getProperty(DBNAME_PROPERTY_KEY, "default"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostProp, portProp, dbProp};
        return dpi;
    }

    private Properties parseUrlforPropertyInfo(String url, Properties defaults) throws SQLException {
        Properties properties = new Properties();
        if (defaults != null) {
            properties.putAll((Map<?, ?>)defaults);
        }
        if (url == null || !url.startsWith(URL_PREFIX)) {
            throw new SQLException("Invalid connection url: " + url);
        }
        properties.put(HOST_PROPERTY_KEY, Utils.getHost((String)url));
        properties.put(PORT_PROPERTY_KEY, Utils.getPort((String)url));
        properties.put(DBNAME_PROPERTY_KEY, Utils.getDB((String)url));
        properties.putAll((Map<?, ?>)Utils.getURLProperties((String)url));
        return properties;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

