/*
 * Decompiled with CFR 0.152.
 */
package com.dataphin.jdbc;

import com.dataphin.jdbc.Utils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;

public class OsResultSetMetaData
implements ResultSetMetaData {
    private List<String> columnNames;
    private List<String> columnTypes;
    private static final String TYPE_NAME = "string";

    public OsResultSetMetaData(List<String> columnNames, List<String> columnTypes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        String type = (String)this.columnTypes.get(this.toZeroIndex(column));
        return TYPE_NAME.equalsIgnoreCase(type);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return (String)this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return (String)this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "  ";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        String type = (String)this.columnTypes.get(this.toZeroIndex(column));
        return Utils.getJdbcType((String)type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return (String)this.columnTypes.get(this.toZeroIndex(column));
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return (String)this.columnTypes.get(this.toZeroIndex(column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    private int toZeroIndex(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        return column - 1;
    }
}

