/*
 * Decompiled with CFR 0.152.
 */
package com.dataphin.jdbc;

import com.dataphin.jdbc.Client;
import com.dataphin.jdbc.OsResultSet;
import com.dataphin.jdbc.dto.OsInstance;
import com.dataphin.jdbc.dto.OsResult;
import com.dataphin.jdbc.dto.OsState;
import com.dataphin.jdbc.dto.ResultDTO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class OsStatement
implements Statement {
    private static final int DEFAULT_FETCH_SIZE = 1000;
    private static final String RUNNING_STATE = "running";
    private static final String FAILED_STATE = "failed";
    private static final String WAITING_STATE = "waiting";
    private static final long QUERY_STATE_INTERVAL = 2000L;
    Client client;
    private boolean isClosed = false;
    private ResultSet resultSet = null;
    private int maxRows;
    private int queryTimeout;
    private boolean isCancelled;
    private SQLWarning warningChain;
    private int fetchSize;
    private Connection connection;

    OsStatement(Connection connection, Client client) {
        this.connection = connection;
        this.client = client;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.client.closeStatement();
        this.client = null;
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkConnection("setMaxRows");
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            throw new SQLFeatureNotSupportedException("Method not supported");
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkConnection("getQueryTimeout");
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection("getWarnings");
        return this.warningChain;
    }

    @Override
    public void clearWarnings() {
        this.warningChain = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkConnection("execute");
        ResultDTO result = this.client.execute(new OsInstance(sql, this.client.getDatabase(), this.client.getProperties()));
        if (((OsResult)result.getData()).getType().equalsIgnoreCase("sync")) {
            this.resultSet = new OsResultSet((OsResult)result.getData(), this.client);
            return true;
        }
        OsState state = (OsState)this.client.state().getData();
        while (RUNNING_STATE.equalsIgnoreCase(state.getState())) {
            try {
                Thread.sleep(2000L);
                state = (OsState)this.client.state().getData();
            }
            catch (InterruptedException e) {
                throw new SQLException("check task state error");
            }
        }
        if (FAILED_STATE.equalsIgnoreCase(state.getState())) {
            throw new SQLException(state.getLog());
        }
        if (WAITING_STATE.equalsIgnoreCase(state.getState())) {
            return false;
        }
        ResultDTO next = this.client.next();
        this.resultSet = new OsResultSet((OsResult)next.getData(), this.client);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException("Not supported direction " + direction);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection("setFetchSize");
        if (rows > 0) {
            this.fetchSize = rows;
        } else if (rows == 0) {
            this.fetchSize = 1000;
        } else {
            throw new SQLException("Fetch size must be greater or equal to 0");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection("getConnection");
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't " + action + " after statement has been closed");
        }
    }
}

