/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import javax.annotation.Nullable;

@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    @LazyInit
    private transient Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    Converter(boolean handleNullAutomatically) {
        this.handleNullAutomatically = handleNullAutomatically;
    }

    protected abstract B doForward(A var1);

    protected abstract A doBackward(B var1);

    @Nullable
    @CanIgnoreReturnValue
    public final B convert(@Nullable A a) {
        return (B)this.correctedDoForward(a);
    }

    @Nullable
    B correctedDoForward(@Nullable A a) {
        if (this.handleNullAutomatically) {
            return (B)(a == null ? null : Preconditions.checkNotNull((Object)this.doForward(a)));
        }
        return (B)this.doForward(a);
    }

    @Nullable
    A correctedDoBackward(@Nullable B b) {
        if (this.handleNullAutomatically) {
            return (A)(b == null ? null : Preconditions.checkNotNull((Object)this.doBackward(b)));
        }
        return (A)this.doBackward(b);
    }

    @CanIgnoreReturnValue
    public Iterable<B> convertAll(Iterable<? extends A> fromIterable) {
        Preconditions.checkNotNull(fromIterable, (Object)"fromIterable");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @CanIgnoreReturnValue
    public Converter<B, A> reverse() {
        Converter result = this.reverse;
        return result == null ? (this.reverse = new ReverseConverter(this)) : result;
    }

    public final <C> Converter<A, C> andThen(Converter<B, C> secondConverter) {
        return this.doAndThen(secondConverter);
    }

    <C> Converter<A, C> doAndThen(Converter<B, C> secondConverter) {
        return new ConverterComposition(this, (Converter)Preconditions.checkNotNull(secondConverter));
    }

    @Deprecated
    @Nullable
    @CanIgnoreReturnValue
    public final B apply(@Nullable A a) {
        return (B)this.convert(a);
    }

    public boolean equals(@Nullable Object object) {
        return super.equals(object);
    }

    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> forwardFunction, Function<? super B, ? extends A> backwardFunction) {
        return new FunctionBasedConverter(forwardFunction, backwardFunction, null);
    }

    public static <T> Converter<T, T> identity() {
        return IdentityConverter.INSTANCE;
    }
}

