/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.CommonPattern;
import com.google.common.base.JdkPattern;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.none(), Integer.MAX_VALUE);
    }

    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        this.strategy = strategy;
        this.omitEmptyStrings = omitEmptyStrings;
        this.trimmer = trimmer;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        return Splitter.on((CharMatcher)CharMatcher.is((char)separator));
    }

    public static Splitter on(CharMatcher separatorMatcher) {
        Preconditions.checkNotNull((Object)separatorMatcher);
        return new Splitter((Strategy)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Splitter on(String separator) {
        Preconditions.checkArgument((separator.length() != 0 ? 1 : 0) != 0, (Object)"The separator may not be the empty string.");
        if (separator.length() == 1) {
            return Splitter.on((char)separator.charAt(0));
        }
        return new Splitter((Strategy)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GwtIncompatible
    public static Splitter on(Pattern separatorPattern) {
        return Splitter.on((CommonPattern)new JdkPattern(separatorPattern));
    }

    private static Splitter on(CommonPattern separatorPattern) {
        Preconditions.checkArgument((!separatorPattern.matcher((CharSequence)"").matches() ? 1 : 0) != 0, (String)"The pattern may not match the empty string: %s", (Object)separatorPattern);
        return new Splitter((Strategy)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GwtIncompatible
    public static Splitter onPattern(String separatorPattern) {
        return Splitter.on((CommonPattern)Platform.compilePattern((String)separatorPattern));
    }

    public static Splitter fixedLength(int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"The length may not be less than 1");
        return new Splitter((Strategy)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    public Splitter limit(int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"must be greater than zero: %s", (int)limit);
        return new Splitter(this.strategy, this.omitEmptyStrings, this.trimmer, limit);
    }

    public Splitter trimResults() {
        return this.trimResults(CharMatcher.whitespace());
    }

    public Splitter trimResults(CharMatcher trimmer) {
        Preconditions.checkNotNull((Object)trimmer);
        return new Splitter(this.strategy, this.omitEmptyStrings, trimmer, this.limit);
    }

    public Iterable<String> split(CharSequence sequence) {
        Preconditions.checkNotNull((Object)sequence);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Iterator<String> splittingIterator(CharSequence sequence) {
        return this.strategy.iterator(this, sequence);
    }

    @Beta
    public List<String> splitToList(CharSequence sequence) {
        Preconditions.checkNotNull((Object)sequence);
        Iterator iterator = this.splittingIterator(sequence);
        ArrayList result = new ArrayList();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(result);
    }

    @Beta
    public MapSplitter withKeyValueSeparator(String separator) {
        return this.withKeyValueSeparator(Splitter.on((String)separator));
    }

    @Beta
    public MapSplitter withKeyValueSeparator(char separator) {
        return this.withKeyValueSeparator(Splitter.on((char)separator));
    }

    @Beta
    public MapSplitter withKeyValueSeparator(Splitter keyValueSplitter) {
        return new MapSplitter(this, keyValueSplitter, null);
    }

    static /* synthetic */ Iterator access$000(Splitter x0, CharSequence x1) {
        return x0.splittingIterator(x1);
    }

    static /* synthetic */ CharMatcher access$200(Splitter x0) {
        return x0.trimmer;
    }

    static /* synthetic */ boolean access$300(Splitter x0) {
        return x0.omitEmptyStrings;
    }

    static /* synthetic */ int access$400(Splitter x0) {
        return x0.limit;
    }
}

