/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.RetainedWith;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient Map<K, V> delegate;
    @RetainedWith
    transient AbstractBiMap<V, K> inverse;
    private transient Set<K> keySet;
    private transient Set<V> valueSet;
    private transient Set<Map.Entry<K, V>> entrySet;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    AbstractBiMap(Map<K, V> forward, Map<V, K> backward) {
        this.setDelegates(forward, backward);
    }

    private AbstractBiMap(Map<K, V> backward, AbstractBiMap<V, K> forward) {
        this.delegate = backward;
        this.inverse = forward;
    }

    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @CanIgnoreReturnValue
    K checkKey(@Nullable K key) {
        return key;
    }

    @CanIgnoreReturnValue
    V checkValue(@Nullable V value) {
        return value;
    }

    void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        Preconditions.checkState((this.delegate == null ? 1 : 0) != 0);
        Preconditions.checkState((this.inverse == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)forward.isEmpty());
        Preconditions.checkArgument((boolean)backward.isEmpty());
        Preconditions.checkArgument((forward != backward ? 1 : 0) != 0);
        this.delegate = forward;
        this.inverse = this.makeInverse(backward);
    }

    AbstractBiMap<V, K> makeInverse(Map<V, K> backward) {
        return new Inverse(backward, this);
    }

    void setInverse(AbstractBiMap<V, K> inverse) {
        this.inverse = inverse;
    }

    public boolean containsValue(@Nullable Object value) {
        return this.inverse.containsKey(value);
    }

    @CanIgnoreReturnValue
    public V put(@Nullable K key, @Nullable V value) {
        return (V)this.putInBothMaps(key, value, false);
    }

    @CanIgnoreReturnValue
    public V forcePut(@Nullable K key, @Nullable V value) {
        return (V)this.putInBothMaps(key, value, true);
    }

    private V putInBothMaps(@Nullable K key, @Nullable V value, boolean force) {
        this.checkKey(key);
        this.checkValue(value);
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equal(value, (Object)this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else {
            Preconditions.checkArgument((!this.containsValue(value) ? 1 : 0) != 0, (String)"value already present: %s", value);
        }
        V oldValue = this.delegate.put(key, value);
        this.updateInverseMap(key, containedKey, oldValue, value);
        return oldValue;
    }

    private void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(oldValue);
        }
        this.inverse.delegate.put(newValue, key);
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object key) {
        return (V)(this.containsKey(key) ? this.removeFromBothMaps(key) : null);
    }

    @CanIgnoreReturnValue
    private V removeFromBothMaps(Object key) {
        Object oldValue = this.delegate.remove(key);
        this.removeFromInverseMap(oldValue);
        return oldValue;
    }

    private void removeFromInverseMap(V oldValue) {
        this.inverse.delegate.remove(oldValue);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    public Set<K> keySet() {
        Set result = this.keySet;
        return result == null ? (this.keySet = new KeySet(this, null)) : result;
    }

    public Set<V> values() {
        Set result = this.valueSet;
        return result == null ? (this.valueSet = new ValueSet(this, null)) : result;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Set result = this.entrySet;
        return result == null ? (this.entrySet = new EntrySet(this, null)) : result;
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        Iterator iterator = this.delegate.entrySet().iterator();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Map access$100(AbstractBiMap x0) {
        return x0.delegate;
    }

    static /* synthetic */ Object access$200(AbstractBiMap x0, Object x1) {
        return x0.removeFromBothMaps(x1);
    }

    static /* synthetic */ void access$500(AbstractBiMap x0, Object x1, boolean x2, Object x3, Object x4) {
        x0.updateInverseMap(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$600(AbstractBiMap x0, Object x1) {
        x0.removeFromInverseMap(x1);
    }
}

