/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapBasedMultimap;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultimap<K, V>
extends AbstractMultimap<K, V>
implements Serializable {
    private transient Map<K, Collection<V>> map;
    private transient int totalSize;
    private static final long serialVersionUID = 2447537837011683357L;

    protected AbstractMapBasedMultimap(Map<K, Collection<V>> map) {
        Preconditions.checkArgument((boolean)map.isEmpty());
        this.map = map;
    }

    final void setMap(Map<K, Collection<V>> map) {
        this.map = map;
        this.totalSize = 0;
        for (Collection<V> values : map.values()) {
            Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0);
            this.totalSize += values.size();
        }
    }

    Collection<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass(this.createCollection());
    }

    abstract Collection<V> createCollection();

    Collection<V> createCollection(@Nullable K key) {
        return this.createCollection();
    }

    Map<K, Collection<V>> backingMap() {
        return this.map;
    }

    public int size() {
        return this.totalSize;
    }

    public boolean containsKey(@Nullable Object key) {
        return this.map.containsKey(key);
    }

    public boolean put(@Nullable K key, @Nullable V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            if (collection.add(value)) {
                ++this.totalSize;
                this.map.put(key, collection);
                return true;
            }
            throw new AssertionError((Object)"New Collection violated the Collection spec");
        }
        if (collection.add(value)) {
            ++this.totalSize;
            return true;
        }
        return false;
    }

    private Collection<V> getOrCreateCollection(@Nullable K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
            this.map.put(key, collection);
        }
        return collection;
    }

    public Collection<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        Iterator<V> iterator = values.iterator();
        if (!iterator.hasNext()) {
            return this.removeAll(key);
        }
        Collection collection = this.getOrCreateCollection(key);
        Collection oldValues = this.createCollection();
        oldValues.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        while (iterator.hasNext()) {
            if (!collection.add(iterator.next())) continue;
            ++this.totalSize;
        }
        return this.unmodifiableCollectionSubclass(oldValues);
    }

    public Collection<V> removeAll(@Nullable Object key) {
        Collection collection = (Collection)this.map.remove(key);
        if (collection == null) {
            return this.createUnmodifiableEmptyCollection();
        }
        Collection output = this.createCollection();
        output.addAll(collection);
        this.totalSize -= collection.size();
        collection.clear();
        return this.unmodifiableCollectionSubclass(output);
    }

    Collection<V> unmodifiableCollectionSubclass(Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)collection);
        }
        if (collection instanceof Set) {
            return Collections.unmodifiableSet((Set)collection);
        }
        if (collection instanceof List) {
            return Collections.unmodifiableList((List)collection);
        }
        return Collections.unmodifiableCollection(collection);
    }

    public void clear() {
        for (Collection collection : this.map.values()) {
            collection.clear();
        }
        this.map.clear();
        this.totalSize = 0;
    }

    public Collection<V> get(@Nullable K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createCollection(key);
        }
        return this.wrapCollection(key, collection);
    }

    Collection<V> wrapCollection(@Nullable K key, Collection<V> collection) {
        if (collection instanceof SortedSet) {
            return new WrappedSortedSet(this, key, (SortedSet)collection, null);
        }
        if (collection instanceof Set) {
            return new WrappedSet(this, key, (Set)collection);
        }
        if (collection instanceof List) {
            return this.wrapList(key, (List)collection, null);
        }
        return new WrappedCollection(this, key, collection, null);
    }

    private List<V> wrapList(@Nullable K key, List<V> list, @Nullable WrappedCollection ancestor) {
        return list instanceof RandomAccess ? new RandomAccessWrappedList(this, key, list, ancestor) : new WrappedList(this, key, list, ancestor);
    }

    private Iterator<V> iteratorOrListIterator(Collection<V> collection) {
        return collection instanceof List ? ((List)collection).listIterator() : collection.iterator();
    }

    Set<K> createKeySet() {
        return this.map instanceof SortedMap ? new SortedKeySet(this, (SortedMap)this.map) : new KeySet(this, this.map);
    }

    private void removeValuesForKey(Object key) {
        Collection collection = (Collection)Maps.safeRemove((Map)this.map, (Object)key);
        if (collection != null) {
            int count = collection.size();
            collection.clear();
            this.totalSize -= count;
        }
    }

    public Collection<V> values() {
        return super.values();
    }

    Iterator<V> valueIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Collection<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Map<K, Collection<V>> createAsMap() {
        return this.map instanceof SortedMap ? new SortedAsMap(this, (SortedMap)this.map) : new AsMap(this, this.map);
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultimap x0) {
        return x0.map;
    }

    static /* synthetic */ Iterator access$100(AbstractMapBasedMultimap x0, Collection x1) {
        return x0.iteratorOrListIterator(x1);
    }

    static /* synthetic */ int access$210(AbstractMapBasedMultimap x0) {
        return x0.totalSize--;
    }

    static /* synthetic */ int access$208(AbstractMapBasedMultimap x0) {
        return x0.totalSize++;
    }

    static /* synthetic */ int access$212(AbstractMapBasedMultimap x0, int x1) {
        return x0.totalSize += x1;
    }

    static /* synthetic */ int access$220(AbstractMapBasedMultimap x0, int x1) {
        return x0.totalSize -= x1;
    }

    static /* synthetic */ List access$300(AbstractMapBasedMultimap x0, Object x1, List x2, WrappedCollection x3) {
        return x0.wrapList(x1, x2, x3);
    }

    static /* synthetic */ void access$400(AbstractMapBasedMultimap x0, Object x1) {
        x0.removeValuesForKey(x1);
    }
}

