/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Count;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private transient Map<E, Count> backingMap;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = -2250766705698539974L;

    protected AbstractMapBasedMultiset(Map<E, Count> backingMap) {
        this.backingMap = (Map)Preconditions.checkNotNull(backingMap);
        this.size = super.size();
    }

    void setBackingMap(Map<E, Count> backingMap) {
        this.backingMap = backingMap;
    }

    public Set<Multiset.Entry<E>> entrySet() {
        return super.entrySet();
    }

    Iterator<Multiset.Entry<E>> entryIterator() {
        Iterator backingEntries = this.backingMap.entrySet().iterator();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void clear() {
        for (Count frequency : this.backingMap.values()) {
            frequency.set(0);
        }
        this.backingMap.clear();
        this.size = 0L;
    }

    int distinctElements() {
        return this.backingMap.size();
    }

    public int size() {
        return Ints.saturatedCast((long)this.size);
    }

    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator(this);
    }

    public int count(@Nullable Object element) {
        Count frequency = (Count)Maps.safeGet((Map)this.backingMap, (Object)element);
        return frequency == null ? 0 : frequency.get();
    }

    @CanIgnoreReturnValue
    public int add(@Nullable E element, int occurrences) {
        int oldCount;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument((occurrences > 0 ? 1 : 0) != 0, (String)"occurrences cannot be negative: %s", (int)occurrences);
        Count frequency = (Count)this.backingMap.get(element);
        if (frequency == null) {
            oldCount = 0;
            this.backingMap.put(element, new Count(occurrences));
        } else {
            oldCount = frequency.get();
            long newCount = (long)oldCount + (long)occurrences;
            Preconditions.checkArgument((newCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"too many occurrences: %s", (long)newCount);
            frequency.add(occurrences);
        }
        this.size += (long)occurrences;
        return oldCount;
    }

    @CanIgnoreReturnValue
    public int remove(@Nullable Object element, int occurrences) {
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument((occurrences > 0 ? 1 : 0) != 0, (String)"occurrences cannot be negative: %s", (int)occurrences);
        Count frequency = (Count)this.backingMap.get(element);
        if (frequency == null) {
            return 0;
        }
        int oldCount = frequency.get();
        if (oldCount > occurrences) {
            numberRemoved = occurrences;
        } else {
            numberRemoved = oldCount;
            this.backingMap.remove(element);
        }
        frequency.add(-numberRemoved);
        this.size -= (long)numberRemoved;
        return oldCount;
    }

    @CanIgnoreReturnValue
    public int setCount(@Nullable E element, int count) {
        int oldCount;
        CollectPreconditions.checkNonnegative((int)count, (String)"count");
        if (count == 0) {
            Count existingCounter = (Count)this.backingMap.remove(element);
            oldCount = AbstractMapBasedMultiset.getAndSet((Count)existingCounter, (int)count);
        } else {
            Count existingCounter = (Count)this.backingMap.get(element);
            oldCount = AbstractMapBasedMultiset.getAndSet((Count)existingCounter, (int)count);
            if (existingCounter == null) {
                this.backingMap.put(element, new Count(count));
            }
        }
        this.size += (long)(count - oldCount);
        return oldCount;
    }

    private static int getAndSet(@Nullable Count i, int count) {
        if (i == null) {
            return 0;
        }
        return i.getAndSet(count);
    }

    @GwtIncompatible
    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultiset x0) {
        return x0.backingMap;
    }

    static /* synthetic */ long access$122(AbstractMapBasedMultiset x0, long x1) {
        return x0.size -= x1;
    }

    static /* synthetic */ long access$110(AbstractMapBasedMultiset x0) {
        return x0.size--;
    }
}

