/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    private transient Set<E> elementSet;
    private transient Set<Multiset.Entry<E>> entrySet;

    AbstractMultiset() {
    }

    @Override
    public int size() {
        return Multisets.sizeImpl((Multiset)this);
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return this.count(element) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl((Multiset)this);
    }

    public int count(@Nullable Object element) {
        for (Multiset.Entry entry : this.entrySet()) {
            if (!Objects.equal((Object)entry.getElement(), (Object)element)) continue;
            return entry.getCount();
        }
        return 0;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean add(@Nullable E element) {
        this.add(element, 1);
        return true;
    }

    @CanIgnoreReturnValue
    public int add(@Nullable E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@Nullable Object element) {
        return this.remove(element, 1) > 0;
    }

    @CanIgnoreReturnValue
    public int remove(@Nullable Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @CanIgnoreReturnValue
    public int setCount(@Nullable E element, int count) {
        return Multisets.setCountImpl((Multiset)this, element, (int)count);
    }

    @CanIgnoreReturnValue
    public boolean setCount(@Nullable E element, int oldCount, int newCount) {
        return Multisets.setCountImpl((Multiset)this, element, (int)oldCount, (int)newCount);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addAll(Collection<? extends E> elementsToAdd) {
        return Multisets.addAllImpl((Multiset)this, elementsToAdd);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeAll(Collection<?> elementsToRemove) {
        return Multisets.removeAllImpl((Multiset)this, elementsToRemove);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean retainAll(Collection<?> elementsToRetain) {
        return Multisets.retainAllImpl((Multiset)this, elementsToRetain);
    }

    @Override
    public void clear() {
        Iterators.clear((Iterator)this.entryIterator());
    }

    public Set<E> elementSet() {
        Set result = this.elementSet;
        if (result == null) {
            this.elementSet = result = this.createElementSet();
        }
        return result;
    }

    Set<E> createElementSet() {
        return new ElementSet(this);
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    abstract int distinctElements();

    public Set<Multiset.Entry<E>> entrySet() {
        Set result = this.entrySet;
        if (result == null) {
            this.entrySet = result = this.createEntrySet();
        }
        return result;
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet(this);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Multisets.equalsImpl((Multiset)this, (Object)object);
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }
}

